/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.parser.TocFragmentParser;
import org.eclipse.help.internal.webapp.servlet.TocFragmentServlet;

public class TocFragmentService
extends TocFragmentServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean boolIsJSON;
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setContentType("application/xml; charset=UTF-8");
        String response = this.processRequest(req, resp);
        String returnType = req.getParameter("returnType");
        boolean bl = boolIsJSON = returnType != null && returnType.equalsIgnoreCase("json");
        if (boolIsJSON) {
            resp.setContentType("text/plain");
            String toc = req.getParameter("toc");
            String path = req.getParameter("path");
            response = this.getJSONResponse(toc, path, response);
        }
        resp.getWriter().write(response);
    }

    protected String getJSONResponse(String toc, String path, String xmlResource) throws IOException {
        TocFragmentParser tocParser = new TocFragmentParser();
        InputStream is = null;
        try {
            if (xmlResource != null) {
                is = new ByteArrayInputStream(xmlResource.getBytes("UTF-8"));
                int level = 0;
                if (toc != null && toc.length() > 0) {
                    ++level;
                    if (path != null && path.length() > 0) {
                        String[] pathIdxs = path.split("_");
                        level += pathIdxs.length;
                    }
                }
                tocParser.parse(is, level);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (is != null) {
            is.close();
        }
        return tocParser.toJSON();
    }
}

