/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.ui.IWorkbenchPage;

public class RefreshHandler
extends BaseControlViewHandler {
    @Nullable
    private TargetNodeComponent fNode;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TargetNodeComponent node;
        this.fLock.lock();
        try {
            node = this.fNode;
        }
        finally {
            this.fLock.unlock();
        }
        if (node != null) {
            node.refresh();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TargetNodeComponent node = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                boolean isConnected;
                if (!(element instanceof TraceControlComponent)) continue;
                TraceControlComponent component = (TraceControlComponent)element;
                boolean bl = isConnected = component.getTargetNodeState() == TargetNodeState.CONNECTED;
                if (!isConnected) continue;
                while (component != null && component.getClass() != TargetNodeComponent.class) {
                    component = (TraceControlComponent)component.getParent();
                }
                if (component == null) continue;
                node = (TargetNodeComponent)component;
            }
        }
        boolean isEnabled = node != null;
        this.fLock.lock();
        try {
            this.fNode = null;
            if (isEnabled) {
                this.fNode = node;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

