/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelThreadInformationProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class KernelTidAspect
extends LinuxTidAspect {
    public static final KernelTidAspect INSTANCE = new KernelTidAspect();

    private KernelTidAspect() {
    }

    @Override
    @Nullable
    public Integer resolve(ITmfEvent event) {
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpuObj == null) {
            return null;
        }
        Integer cpu = (Integer)cpuObj;
        KernelAnalysisModule analysis = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)event.getTrace(), KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (analysis == null) {
            return null;
        }
        Integer tid = KernelThreadInformationProvider.getThreadOnCpu(analysis, cpu.intValue(), event.getTimestamp().getValue());
        if (tid != null) {
            return tid;
        }
        return null;
    }
}

