/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestReader {
    private static final String SCHEMA_FOLDER_NAME = "schema";
    private static final String EXPORT_MANIFEST_SCHEMA_FILE_NAME = "export-manifest.xsd";
    private static final TracePackageElement[] EMPTY_ARRAY = new TracePackageElement[0];

    public static void validateManifest(InputStream input) throws IOException {
        URL schemaFileUrl = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(SCHEMA_FOLDER_NAME).append(EXPORT_MANIFEST_SCHEMA_FILE_NAME), null);
        if (schemaFileUrl == null) {
            throw new IOException(MessageFormat.format(Messages.TracePackageExtractManifestOperation_SchemaFileNotFound, EXPORT_MANIFEST_SCHEMA_FILE_NAME));
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(schemaFileUrl.openStream()));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(input));
        }
        catch (SAXException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
        catch (IOException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
    }

    public static TracePackageElement[] loadElementsFromManifest(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        Element rootElement = doc.getDocumentElement();
        return ManifestReader.loadElementsFromNode(rootElement);
    }

    public static TracePackageElement[] loadElementsFromNode(Element rootElement) {
        ArrayList<TracePackageTraceElement> packageElements = new ArrayList<TracePackageTraceElement>();
        NodeList traceElements = rootElement.getElementsByTagName("trace");
        int i = 0;
        while (i < traceElements.getLength()) {
            Node traceNode = traceElements.item(i);
            if (traceNode.getNodeType() == 1) {
                Element traceElement = (Element)traceNode;
                String traceName = traceElement.getAttribute("name");
                String traceType = traceElement.getAttribute("type");
                TracePackageTraceElement element = new TracePackageTraceElement(null, traceName, traceType);
                NodeList fileElements = traceElement.getElementsByTagName("file");
                int j = 0;
                while (j < fileElements.getLength()) {
                    Node fileNode = fileElements.item(j);
                    if (fileNode.getNodeType() == 1) {
                        Element fileElement = (Element)fileNode;
                        String fileName = fileElement.getAttribute("name");
                        new TracePackageFilesElement((TracePackageElement)element, fileName);
                    }
                    ++j;
                }
                NodeList suppFilesElements = traceElement.getElementsByTagName("supplementary-file");
                if (suppFilesElements.getLength() > 0) {
                    TracePackageSupplFilesElement supplFilesElement = new TracePackageSupplFilesElement(element);
                    int j2 = 0;
                    while (j2 < suppFilesElements.getLength()) {
                        Node suppFileNode = suppFilesElements.item(j2);
                        if (suppFileNode.getNodeType() == 1) {
                            Element suppFileElement = (Element)suppFileNode;
                            String fileName = suppFileElement.getAttribute("name");
                            new TracePackageSupplFileElement(fileName, (TracePackageElement)supplFilesElement);
                        }
                        ++j2;
                    }
                }
                ArrayList<Map<String, String>> bookmarkAttribs = new ArrayList<Map<String, String>>();
                NodeList bookmarksElements = traceElement.getElementsByTagName("bookmarks");
                int j3 = 0;
                while (j3 < bookmarksElements.getLength()) {
                    Node bookmarksNode = bookmarksElements.item(j3);
                    if (bookmarksNode.getNodeType() == 1) {
                        NodeList bookmarkElements = traceElement.getElementsByTagName("bookmark");
                        int k = 0;
                        while (k < bookmarkElements.getLength()) {
                            Node bookmarkNode = bookmarkElements.item(k);
                            if (bookmarkNode.getNodeType() == 1) {
                                Element bookmarkElement = (Element)bookmarkNode;
                                NamedNodeMap attributesMap = bookmarkElement.getAttributes();
                                HashMap<String, String> attribs = new HashMap<String, String>();
                                int l = 0;
                                while (l < attributesMap.getLength()) {
                                    Node item = attributesMap.item(l);
                                    attribs.put(item.getNodeName(), item.getNodeValue());
                                    ++l;
                                }
                                bookmarkAttribs.add(attribs);
                            }
                            ++k;
                        }
                    }
                    ++j3;
                }
                if (!bookmarkAttribs.isEmpty()) {
                    new TracePackageBookmarkElement(element, bookmarkAttribs);
                }
                packageElements.add(element);
            }
            ++i;
        }
        return packageElements.toArray(EMPTY_ARRAY);
    }
}

