/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

public class TmfCommonXLineChartTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    public TmfCommonXLineChartTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            double xCoordinate = xAxis.getDataCoordinate(e.x);
            ISeries[] series = this.getChart().getSeriesSet().getSeries();
            if (xCoordinate < 0.0 || series.length == 0) {
                return;
            }
            double[] xS = series[0].getXSeries();
            if (xS == null) {
                return;
            }
            int index = 0;
            int i = 0;
            while (i < xS.length) {
                if (xS[i] > xCoordinate) break;
                index = i++;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("time=");
            buffer.append(new TmfTimestamp((long)xCoordinate + this.getChartViewer().getTimeOffset(), -9).toString());
            buffer.append('\n');
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                double[] yS = serie.getYSeries();
                if (yS != null && yS.length > index) {
                    buffer.append(serie.getId());
                    buffer.append('=');
                    buffer.append(yS[index]);
                    buffer.append('\n');
                }
                ++n2;
            }
            this.getChart().getPlotArea().setToolTipText(buffer.toString());
            this.getChart().redraw();
        }
    }
}

