/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class PerfEventLayout
implements IKernelAnalysisEventLayout {
    private static final PerfEventLayout INSTANCE = new PerfEventLayout();
    private static final Collection<String> WAKEUP_EVENTS = (Collection)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)"sched:sched_wakeup", (Object)"sched:sched_wakeup_new"));

    private PerfEventLayout() {
    }

    public static PerfEventLayout getInstance() {
        return INSTANCE;
    }

    public String eventIrqHandlerEntry() {
        return "irq:irq_handler_exit";
    }

    public String eventIrqHandlerExit() {
        return "irq:irq_handler_entry";
    }

    public String eventSoftIrqEntry() {
        return "irq:softirq_entry";
    }

    public String eventSoftIrqExit() {
        return "irq:softirq_exit";
    }

    public String eventSoftIrqRaise() {
        return "irq:softirq_raise";
    }

    public String eventSchedSwitch() {
        return "sched:sched_switch";
    }

    public String eventSchedPiSetprio() {
        return "sched:sched_pi_setprio";
    }

    public Collection<String> eventsSchedWakeup() {
        return WAKEUP_EVENTS;
    }

    public String eventSchedProcessFork() {
        return "sched:sched_process_fork";
    }

    public String eventSchedProcessExit() {
        return "sched:sched_process_exit";
    }

    public String eventSchedProcessFree() {
        return "sched:sched_process_free";
    }

    @Nullable
    public String eventStatedumpProcessState() {
        return null;
    }

    public String eventSyscallEntryPrefix() {
        return "raw_syscalls:sys_enter";
    }

    public String eventCompatSyscallEntryPrefix() {
        return this.eventSyscallEntryPrefix();
    }

    public String eventSyscallExitPrefix() {
        return "raw_syscalls:sys_exit";
    }

    public String fieldIrq() {
        return "irq";
    }

    public String fieldVec() {
        return "vec";
    }

    public String fieldTid() {
        return "pid";
    }

    public String fieldPrevTid() {
        return "prev_pid";
    }

    public String fieldPrevState() {
        return "prev_state";
    }

    public String fieldNextComm() {
        return "next_comm";
    }

    public String fieldNextTid() {
        return "next_pid";
    }

    public String fieldChildComm() {
        return "child_comm";
    }

    public String fieldParentTid() {
        return "parent_pid";
    }

    public String fieldChildTid() {
        return "child_pid";
    }

    public String fieldPrio() {
        return "prio";
    }

    public String fieldNewPrio() {
        return "newprio";
    }

    public String fieldNextPrio() {
        return "next_prio";
    }
}

