/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.variable;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.DsfCastToTypeSupport;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.DsfDebugUITools;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.AbstractElementVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.BreakpointHitUpdatePolicy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.DebugManualUpdatePolicy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableColumnPresentation;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class VariableVMProvider
extends AbstractElementVMProvider
implements IColumnPresentationFactory {
    private IPropertyChangeListener fPreferencesListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("delaySteppingForViewUpdatesEnable")) {
                IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
                VariableVMProvider.this.setDelayEventHandleForViewUpdate(store.getBoolean(property));
            }
        }
    };
    private IPropertyChangeListener fPresentationContextListener = new IPropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent event) {
            VariableVMProvider.this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    VariableVMProvider.this.handleEvent(event);
                }
            });
        }
    };

    public VariableVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.addPropertyChangeListener(this.fPresentationContextListener);
        IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
        store.addPropertyChangeListener(this.fPreferencesListener);
        this.setDelayEventHandleForViewUpdate(store.getBoolean("delaySteppingForViewUpdatesEnable"));
        this.configureLayout();
    }

    @Override
    public void dispose() {
        DsfDebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferencesListener);
        this.getPresentationContext().removePropertyChangeListener(this.fPresentationContextListener);
        super.dispose();
    }

    protected void configureLayout() {
        SyncVariableDataAccess varAccess = new SyncVariableDataAccess(this.getSession());
        RootDMVMNode rootNode = new RootDMVMNode(this);
        this.setRootNode(rootNode);
        VariableVMNode subExpressioNode = new VariableVMNode((AbstractDMVMProvider)this, this.getSession(), varAccess);
        this.addChildNodes(rootNode, new IVMNode[]{subExpressioNode});
        this.hookUpCastingSupport(varAccess, subExpressioNode);
        this.addChildNodes(subExpressioNode, new IVMNode[]{subExpressioNode});
    }

    private void hookUpCastingSupport(final SyncVariableDataAccess syncvarDataAccess, final VariableVMNode variableNode) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), VariableVMProvider.this.getSession().getId());
                    IExpressions2 expressions2 = (IExpressions2)tracker.getService(IExpressions2.class);
                    if (expressions2 != null) {
                        variableNode.setCastToTypeSupport(new DsfCastToTypeSupport(VariableVMProvider.this.getSession(), VariableVMProvider.this, syncvarDataAccess));
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new VariableColumnPresentation();
    }

    @Override
    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.cdt.dsf.ui.VARIABLES_COLUMN_PRESENTATION_ID";
    }

    @Override
    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy(), new DebugManualUpdatePolicy(), new BreakpointHitUpdatePolicy()};
    }

    @Override
    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return newEvent instanceof IRunControl.ISuspendedDMEvent;
    }

    @Override
    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), VariableVMProvider.this.getSession().getId());
                    IExpressions expressionsService = (IExpressions)tracker.getService(IExpressions.class);
                    if (expressionsService instanceof ICachingService) {
                        ((ICachingService)expressionsService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

