/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class CLITraceDumpInfo
extends MIInfo {
    private static final Pattern RESULT_PATTERN_TPINFO = Pattern.compile("Data collected at tracepoint (\\d+), trace frame (\\d+)", 2);
    private String fOutput = null;
    private String fParsedOutput = null;
    private String fTracepointNum = null;
    private String fTraceFrameNumber = null;
    private static final boolean KEEP_HEADER = true;

    public CLITraceDumpInfo(MIOutput out) {
        super(out);
        this.parse(true);
    }

    public CLITraceDumpInfo(MIOutput out, boolean keepHeader) {
        super(out);
        this.parse(keepHeader);
    }

    private void parse(boolean keepHeader) {
        Pattern RESULT_PATTERN_UNWRAPRECORD = Pattern.compile("~\"(.*)\"", 128);
        StringBuffer buf = new StringBuffer();
        if (this.isDone()) {
            MIOOBRecord[] oobs;
            MIOutput out = this.getMIOutput();
            this.fOutput = out.toString();
            MIOOBRecord[] mIOOBRecordArray = oobs = out.getMIOOBRecords();
            int n = oobs.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput && (matcher = RESULT_PATTERN_UNWRAPRECORD.matcher(oob.toString())).find()) {
                    String unwrapped = matcher.group(1);
                    buf.append(unwrapped);
                }
                ++n2;
            }
            this.fParsedOutput = buf.toString();
            Matcher matcher = RESULT_PATTERN_TPINFO.matcher(this.fParsedOutput);
            if (matcher.find()) {
                this.fTracepointNum = matcher.group(1).trim();
                this.fTraceFrameNumber = matcher.group(2).trim();
            }
            this.fParsedOutput = this.fParsedOutput.replaceAll("\\\\n", "\n");
            this.fParsedOutput = this.fParsedOutput.replaceAll("\\\\t+", "\t");
            if (!keepHeader) {
                this.fParsedOutput = this.fParsedOutput.replaceFirst("Data collected at tracepoint \\d+, trace frame \\d+:\\n", "");
            }
        }
    }

    public String getOutput() {
        return this.fOutput;
    }

    public String getContent() {
        return this.fParsedOutput;
    }

    public String getTracepointNumber() {
        return this.fTracepointNum;
    }

    public String getFrameNumber() {
        return this.fTraceFrameNumber;
    }

    public String getTimestamp() {
        return null;
    }
}

