/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.ComponentAddCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.AbstractPaletteDialog;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportArchiveDialog
extends AbstractPaletteDialog {
    private static final int CHECK_ALL_ID = 1025;
    private static final int UNCHECK_ALL_ID = 1026;
    private static final String JAR_LIST_ID = "HISTORY_JAR_LIST";
    private static final String JAR_SUFFIX = ".jar";
    private static final String JAVA_BEAN_KEY = "Java-Bean";
    private static final String JAVA_BEAN_VALUE = "True";
    private static final String JAVA_BEAN_CLASS_SUFFIX = ".class";
    private static final int JAR_COMBO_SIZE = 10;
    private final PaletteInfo m_palette;
    private final CategoryInfo m_initialCategory;
    private Object m_initSelection;
    private Object[] m_initExpanded;
    private Combo m_fileArchiveCombo;
    private CheckboxTableViewer m_classesViewer;
    private Button m_ignoreManifestButton;
    private ToolItem m_browseItem;
    private Menu m_browseMenu;
    private Label m_categoryLabel;
    private Combo m_categoryCombo;
    private Text m_categoryText;
    private Button m_checkButton;
    private Button m_uncheckButton;
    private String m_jarPath;
    private List<PaletteElementInfo> m_elements = Collections.emptyList();
    private List<Command> m_commands = Collections.emptyList();

    public ImportArchiveDialog(Shell parentShell, PaletteInfo palette, CategoryInfo initialCategory) {
        super(parentShell, Messages.ImportArchiveDialog_shellTitle, Messages.ImportArchiveDialog_title, null, Messages.ImportArchiveDialog_message);
        this.setShellStyle(67696);
        this.m_palette = palette;
        this.m_initialCategory = initialCategory;
        this.m_initSelection = EditorState.getActiveJavaInfo().getEditor().getJavaProject().getProject();
        this.m_initExpanded = new Object[]{this.m_initSelection};
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addControlListener((ControlListener)new ControlAdapter(){
            private boolean m_handle;

            public void controlResized(ControlEvent e) {
                if (this.m_handle) {
                    Table table = ImportArchiveDialog.this.m_classesViewer.getTable();
                    Rectangle clientArea = ImportArchiveDialog.this.getShell().getClientArea();
                    if (clientArea.width > 50) {
                        TableColumn[] columns = table.getColumns();
                        columns[0].setWidth(clientArea.width - 30);
                    }
                }
                this.m_handle = true;
            }
        });
    }

    protected void createControls(Composite container) {
        GridLayoutFactory.create((Composite)container).columns(3);
        new Label(container, 0).setText(Messages.ImportArchiveDialog_archiveLabel);
        this.m_fileArchiveCombo = new Combo(container, 8);
        GridDataFactory.create((Control)this.m_fileArchiveCombo).fillH().grabH();
        UiUtils.setVisibleItemCount((Combo)this.m_fileArchiveCombo, (int)10);
        IDialogSettings settings = this.getDialogSettings();
        String[] jarHistory = settings.getArray(JAR_LIST_ID);
        if (jarHistory != null) {
            this.m_fileArchiveCombo.setItems(jarHistory);
        }
        this.m_fileArchiveCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportArchiveDialog.this.chooseFromText(ImportArchiveDialog.this.m_fileArchiveCombo.getText());
            }
        });
        ToolBar browseToolBar = new ToolBar(container, 0x820000);
        this.m_browseItem = new ToolItem(browseToolBar, 4);
        this.m_browseItem.setToolTipText(Messages.ImportArchiveDialog_browseToolTip);
        this.m_browseItem.setImage(DesignerPlugin.getImage((String)"palette/category.gif"));
        this.m_browseMenu = new Menu((Control)browseToolBar);
        MenuItem classpathItem = new MenuItem(this.m_browseMenu, 0);
        classpathItem.setText(Messages.ImportArchiveDialog_classpathItem);
        classpathItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportArchiveDialog.this.chooseFromClasspath();
            }
        });
        MenuItem workspaceItem = new MenuItem(this.m_browseMenu, 0);
        workspaceItem.setText(Messages.ImportArchiveDialog_workspaceItem);
        workspaceItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportArchiveDialog.this.chooseFromWorkspace();
            }
        });
        MenuItem filesystemItem = new MenuItem(this.m_browseMenu, 0);
        filesystemItem.setText(Messages.ImportArchiveDialog_fileSystemItem);
        filesystemItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportArchiveDialog.this.chooseFromFilesystem();
            }
        });
        this.m_browseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = ImportArchiveDialog.this.m_browseItem.getBounds();
                Point location = ImportArchiveDialog.this.m_browseItem.getParent().toDisplay(new Point(bounds.x, bounds.y + bounds.height));
                ImportArchiveDialog.this.m_browseMenu.setLocation(location.x, location.y);
                ImportArchiveDialog.this.m_browseMenu.setVisible(true);
            }
        });
        this.m_ignoreManifestButton = new Button(container, 32);
        GridDataFactory.create((Control)this.m_ignoreManifestButton).spanH(3);
        this.m_ignoreManifestButton.setText(Messages.ImportArchiveDialog_ignoreManifestFlag);
        this.m_classesViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67584);
        GridDataFactory.create((Control)this.m_classesViewer.getControl()).fill().grab().spanH(3).hint(300, 150);
        TableFactory.modify((TableViewer)this.m_classesViewer).headerVisible(true).linesVisible(true);
        TableFactory.modify((TableViewer)this.m_classesViewer).newColumn().text(Messages.ImportArchiveDialog_classesColumn).width(this.getInitialSize().x - 30);
        this.m_classesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_classesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.m_classesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportArchiveDialog.this.calculateFinish();
            }
        });
        this.m_categoryLabel = new Label(container, 0);
        this.m_categoryLabel.setText(Messages.ImportArchiveDialog_categoryLabel);
        this.m_categoryCombo = new Combo(container, 8);
        GridDataFactory.create((Control)this.m_categoryCombo).fillH().grabH().spanH(2);
        UiUtils.setVisibleItemCount((Combo)this.m_categoryCombo, (int)15);
        this.m_categoryCombo.add(Messages.ImportArchiveDialog_categoryNew);
        for (CategoryInfo category : this.m_palette.getCategories()) {
            this.m_categoryCombo.add(category.getName());
        }
        if (this.m_initialCategory == null) {
            this.m_categoryCombo.select(0);
        } else {
            this.m_categoryCombo.select(this.m_palette.getCategories().indexOf(this.m_initialCategory) + 1);
        }
        this.m_categoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportArchiveDialog.this.calculateFinish();
            }
        });
        new Label(container, 0);
        this.m_categoryText = new Text(container, 2048);
        GridDataFactory.create((Control)this.m_categoryText).fillH().grabH().spanH(2);
        this.m_categoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportArchiveDialog.this.calculateFinish();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_checkButton = this.createButton(parent, 1025, Messages.ImportArchiveDialog_selectAllButton, false);
        this.m_uncheckButton = this.createButton(parent, 1026, Messages.ImportArchiveDialog_deselectAllButton, false);
        super.createButtonsForButtonBar(parent);
        this.calculateFinish();
    }

    private void calculateFinish() {
        Object[] checkedElements = this.m_classesViewer.getCheckedElements();
        this.m_uncheckButton.setEnabled(checkedElements.length > 0);
        this.m_checkButton.setEnabled(checkedElements.length < this.m_elements.size());
        boolean catalogEnabled = !this.m_elements.isEmpty();
        this.m_categoryLabel.setEnabled(catalogEnabled);
        this.m_categoryCombo.setEnabled(catalogEnabled);
        this.m_categoryText.setEnabled(catalogEnabled && this.m_categoryCombo.getSelectionIndex() == 0);
        this.validateAll();
    }

    protected String validate() throws Exception {
        if (this.m_elements.isEmpty()) {
            return Messages.ImportArchiveDialog_validateSelectArchive;
        }
        Object[] checkedElements = this.m_classesViewer.getCheckedElements();
        if (checkedElements.length == 0) {
            return Messages.ImportArchiveDialog_validateSelectClass;
        }
        String categoryName = this.m_categoryText.getText();
        if (this.m_categoryCombo.getSelectionIndex() == 0 && categoryName.length() == 0) {
            return Messages.ImportArchiveDialog_validateEmptyCategoryName;
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025 || buttonId == 1026) {
            this.m_classesViewer.setAllChecked(buttonId == 1025);
            this.calculateFinish();
        } else {
            IDialogSettings settings = this.getDialogSettings();
            settings.put(JAR_LIST_ID, this.m_fileArchiveCombo.getItems());
            if (buttonId == 0) {
                this.checkClasspath();
                this.createCommands();
            }
            super.buttonPressed(buttonId);
        }
    }

    private void checkClasspath() {
        try {
            IJavaProject javaProject = EditorState.getActiveJavaInfo().getEditor().getJavaProject();
            boolean addToClassPath = false;
            for (PaletteElementInfo element : this.m_elements) {
                if (javaProject.findType(element.className) != null) continue;
                addToClassPath = true;
                break;
            }
            if (addToClassPath && (addToClassPath = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ImportArchiveDialog_JarNotInClasspathTitle, (String)MessageFormat.format(Messages.ImportArchiveDialog_JarNotInClasspathMessage, this.m_jarPath.toString(), this.m_jarPath.toString())))) {
                ProjectUtils.addJar(javaProject, this.m_jarPath, null);
            }
        }
        catch (Throwable t) {
            DesignerPlugin.log((Throwable)t);
        }
    }

    private void createCommands() {
        this.m_commands = Lists.newArrayList();
        int categoryIndex = this.m_categoryCombo.getSelectionIndex();
        CategoryInfo category = null;
        if (categoryIndex == 0) {
            String name = this.m_categoryText.getText();
            String id = String.valueOf(name) + "_" + Long.toString(System.currentTimeMillis());
            String description = MessageFormat.format(Messages.ImportArchiveDialog_newCategoryDescription, this.m_jarPath);
            this.m_commands.add(new CategoryAddCommand(id, name, description, true, true, null));
            category = new CategoryInfo(id);
        } else {
            category = this.m_palette.getCategories().get(categoryIndex - 1);
        }
        Object[] objectArray = this.m_classesViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            PaletteElementInfo element = (PaletteElementInfo)checkedElement;
            String description = MessageFormat.format(Messages.ImportArchiveDialog_newComponentDescription, element.className);
            this.m_commands.add(new ComponentAddCommand(String.valueOf(element.className) + "_" + Long.toString(System.currentTimeMillis()), element.name, description, true, element.className, category));
            ++n2;
        }
    }

    private void chooseFromClasspath() {
        try {
            HashSet includeObjects = Sets.newHashSet();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IJavaProject javaProject = EditorState.getActiveJavaInfo().getEditor().getJavaProject();
            includeObjects.add(javaProject.getProject());
            String[] stringArray = javaProject.getRequiredProjectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                includeObjects.add(workspaceRoot.getProject(project));
                ++n2;
            }
            this.chooseFromWorkspace(Messages.ImportArchiveDialog_classpathJarSelection, new JarFileFilter(includeObjects));
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    private void chooseFromWorkspace() {
        this.chooseFromWorkspace(Messages.ImportArchiveDialog_workspaceJarSelection, new JarFileFilter());
    }

    private void chooseFromWorkspace(String title, JarFileFilter filter) {
        JarSelectionDialog dialog = new JarSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.ImportArchiveDialog_choosefromWorkspaceMessage);
        dialog.addFilter(filter);
        if (this.m_initSelection != null) {
            dialog.setInitialSelection(this.m_initSelection);
        }
        dialog.setInitialExpanded(this.m_initExpanded);
        dialog.setInput(ResourcesPlugin.getWorkspace());
        dialog.open();
        this.m_initSelection = dialog.getSelection();
        this.m_initExpanded = dialog.getExpandedElements();
        Object[] elements = dialog.getResult();
        if (elements == null || elements.length == 0) {
            return;
        }
        IFile jarFile = null;
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (filter.select(null, null, element)) {
                jarFile = (IFile)element;
                break;
            }
            ++i;
        }
        if (jarFile == null) {
            return;
        }
        this.chooseArchive(jarFile, null);
    }

    private void chooseFromFilesystem() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.jar"});
        String jarPath = dialog.open();
        if (jarPath != null) {
            this.chooseFromText(jarPath);
        }
    }

    private void chooseFromText(String jarName) {
        File jarFile = new File(jarName);
        if (jarFile.exists()) {
            this.chooseArchive(null, jarFile);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(jarName);
            jarFile = new File(res.getLocation().toString());
            if (jarFile.exists()) {
                this.chooseArchive(null, jarFile);
            }
        }
    }

    private void chooseArchive(IFile jarIFile, File jarFile) {
        block13: {
            try {
                try {
                    JarInputStream jarStream;
                    boolean canFile = jarIFile == null;
                    this.m_jarPath = canFile ? jarFile.getAbsolutePath() : jarIFile.getLocation().toPortableString();
                    boolean ignoreManifest = this.m_ignoreManifestButton.getSelection();
                    this.m_elements = Collections.emptyList();
                    if (!ignoreManifest) {
                        jarStream = new JarInputStream(canFile ? new FileInputStream(jarFile) : jarIFile.getContents(true));
                        this.m_elements = this.extractElementsFromJarByManifest(jarStream);
                        jarStream.close();
                    }
                    if (ignoreManifest || this.m_elements.isEmpty()) {
                        if (!ignoreManifest) {
                            String message = MessageFormat.format(Messages.ImportArchiveDialog_hasManifestMessage, this.m_jarPath);
                            ignoreManifest = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ImportArchiveDialog_hasManifestTitle, (String)message);
                        }
                        if (ignoreManifest) {
                            jarStream = new JarInputStream(canFile ? new FileInputStream(jarFile) : jarIFile.getContents(true));
                            this.m_elements = this.extractElementsFromJarAllClasses(jarStream);
                            jarStream.close();
                        }
                    }
                    this.m_classesViewer.setInput((Object)this.m_elements.toArray());
                    int removeIndex = this.m_fileArchiveCombo.indexOf(this.m_jarPath);
                    if (removeIndex != -1) {
                        this.m_fileArchiveCombo.remove(removeIndex);
                    }
                    this.m_fileArchiveCombo.add(this.m_jarPath, 0);
                    int archiveCount = this.m_fileArchiveCombo.getItemCount();
                    if (archiveCount > 10) {
                        this.m_fileArchiveCombo.remove(10, archiveCount - 1);
                    }
                    if (!this.m_fileArchiveCombo.getText().equals(this.m_jarPath)) {
                        this.m_fileArchiveCombo.setText(this.m_jarPath);
                        this.m_fileArchiveCombo.setSelection(new Point(0, this.m_jarPath.length()));
                    }
                    if (this.m_elements.isEmpty()) {
                        this.m_categoryText.setText("");
                        break block13;
                    }
                    String categoryName = canFile ? jarFile.getName() : jarIFile.getName();
                    this.m_categoryText.setText(categoryName.substring(0, categoryName.length() - JAR_SUFFIX.length()));
                }
                catch (Throwable throwable) {
                    this.m_jarPath = null;
                    this.m_elements = Collections.emptyList();
                    this.m_classesViewer.setInput((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
                    this.m_categoryText.setText("");
                    this.calculateFinish();
                }
            }
            finally {
                this.calculateFinish();
            }
        }
    }

    private List<PaletteElementInfo> extractElementsFromJarAllClasses(JarInputStream jarStream) throws Exception {
        List elements = Lists.newArrayList();
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.endsWith(JAVA_BEAN_CLASS_SUFFIX)) continue;
                PaletteElementInfo element = new PaletteElementInfo();
                element.className = StringUtils.substringBeforeLast((String)jarEntryName, (String)JAVA_BEAN_CLASS_SUFFIX).replace('/', '.');
                element.name = CodeUtils.getShortClass(element.className);
                elements.add(element);
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
        Collections.sort(elements, new Comparator<PaletteElementInfo>(){

            @Override
            public int compare(PaletteElementInfo element0, PaletteElementInfo element1) {
                return element0.className.compareToIgnoreCase(element1.className);
            }
        });
        return elements;
    }

    private List<PaletteElementInfo> extractElementsFromJarByManifest(JarInputStream jarStream) throws Exception {
        List elements = Lists.newArrayList();
        Manifest manifest = jarStream.getManifest();
        if (manifest == null) {
            try {
                JarEntry entry;
                while ((entry = jarStream.getNextJarEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equalsIgnoreCase(entry.getName())) continue;
                    byte[] buffer = IOUtils.toByteArray((InputStream)jarStream);
                    jarStream.closeEntry();
                    manifest = new Manifest(new ByteArrayInputStream(buffer));
                    break;
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
                manifest = null;
            }
        }
        if (manifest != null) {
            for (Map.Entry<String, Attributes> mapElement : manifest.getEntries().entrySet()) {
                String beanClass;
                Attributes attributes = mapElement.getValue();
                if (!JAVA_BEAN_VALUE.equalsIgnoreCase(attributes.getValue(JAVA_BEAN_KEY)) || (beanClass = mapElement.getKey()) == null || beanClass.length() <= JAVA_BEAN_CLASS_SUFFIX.length()) continue;
                PaletteElementInfo element = new PaletteElementInfo();
                element.className = StringUtils.substringBeforeLast((String)beanClass, (String)JAVA_BEAN_CLASS_SUFFIX).replace('/', '.');
                element.name = CodeUtils.getShortClass(element.className);
                elements.add(element);
            }
        }
        return elements;
    }

    public List<Command> getCommands() {
        return this.m_commands;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarFileFilter
    extends ViewerFilter {
        private final Collection<?> m_includeObjects;

        public JarFileFilter() {
            this(null);
        }

        public JarFileFilter(Collection<?> includeObjects) {
            this.m_includeObjects = includeObjects;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return "jar".equals(file.getProjectRelativePath().getFileExtension());
            }
            if (!(element instanceof IContainer)) return false;
            if (this.m_includeObjects != null && element instanceof IProject && !this.m_includeObjects.contains(element)) {
                return false;
            }
            try {
                if (!((IContainer)element).isAccessible()) {
                    return false;
                }
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (true) {
                    if (i >= resources.length) {
                        return false;
                    }
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                DesignerPlugin.log((Throwable)e);
            }
            return false;
        }
    }

    private static class JarSelectionDialog
    extends ElementTreeSelectionDialog {
        private Object[] m_expanded;
        private Object m_selection;

        public JarSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        public Object[] getExpandedElements() {
            return this.m_expanded;
        }

        public Object getSelection() {
            return this.m_selection;
        }

        public void setInitialExpanded(Object[] initExpanded) {
            this.m_expanded = initExpanded;
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            TreeViewer viewer = super.createTreeViewer(parent);
            if (this.m_expanded != null && this.m_expanded.length > 0) {
                viewer.setExpandedElements(this.m_expanded);
            }
            return viewer;
        }

        protected void buttonPressed(int buttonId) {
            TreeViewer viewer = this.getTreeViewer();
            this.m_expanded = viewer.getExpandedElements();
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.m_selection = selection.getFirstElement();
            super.buttonPressed(buttonId);
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            PaletteElementInfo paletteElement = (PaletteElementInfo)element;
            return paletteElement.name;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private static class PaletteElementInfo {
        public String className;
        public String name;

        private PaletteElementInfo() {
        }
    }
}

