/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.menu;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectListener;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.draw2d.events.EventTable;

public abstract class AbstractMenuObject
implements IMenuObjectInfo {
    protected final ObjectInfo m_component;
    private final EventTable m_eventTable = new EventTable();

    public AbstractMenuObject(ObjectInfo component) {
        this.m_component = component;
    }

    public Object getToolkitModel() {
        return this.m_component;
    }

    public final void addListener(IMenuObjectListener listener) {
        this.m_eventTable.addListener(IMenuObjectListener.class, listener);
    }

    public final void removeListener(IMenuObjectListener listener) {
        this.m_eventTable.removeListener(IMenuObjectListener.class, listener);
    }

    protected final void fireRefreshListeners() {
        for (IMenuObjectListener listener : this.m_eventTable.getListeners(IMenuObjectListener.class)) {
            listener.refresh();
        }
    }

    protected final void fireDeleteListeners(Object toolkitModel) {
        for (IMenuObjectListener listener : this.m_eventTable.getListeners(IMenuObjectListener.class)) {
            listener.deleting(toolkitModel);
        }
    }

    public final void executeEdit(RunnableEx runnable) {
        ExecutionUtils.run(this.m_component, runnable);
    }

    public final boolean canMove() {
        return GlobalState.getValidatorHelper().canReorder(this.m_component);
    }

    public final boolean canReparent() {
        return GlobalState.getValidatorHelper().canReparent(this.m_component);
    }

    protected final boolean isRoot() {
        return MenuObjectInfoUtils.getMenuInfo(this.m_component.getParent()) == null;
    }

    protected final boolean isRootFor(ObjectInfo child) {
        return this.isRoot() && child != null && this.m_component.isItOrParentOf(child);
    }
}

