/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d.scroll;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wb.internal.draw2d.scroll.ScrollModel;

public class HorizontalScrollModel
extends ScrollModel {
    private final Canvas m_canvas;

    public HorizontalScrollModel(Canvas canvas) {
        super(canvas.getHorizontalBar());
        this.m_canvas = canvas;
    }

    protected void handlePositiveScrolling(int delta, int newSelection) {
        Rectangle clientArea = this.m_canvas.getClientArea();
        this.m_canvas.scroll(0, 0, delta, 0, clientArea.width - delta, clientArea.height, true);
        this.m_selection = newSelection;
        this.m_canvas.redraw(clientArea.width - delta, 0, delta, clientArea.height, true);
    }

    protected void handleNegativeScrolling(int delta, int newSelection) {
        Rectangle clientArea = this.m_canvas.getClientArea();
        this.m_canvas.scroll(delta, 0, 0, 0, clientArea.width - delta, clientArea.height, true);
        this.m_selection = newSelection;
        this.m_canvas.redraw(0, 0, delta, clientArea.height, true);
    }
}

