/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.google.common.collect.Lists;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.FormSpecs;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public class FormDimensionUtils {
    private static Field[] m_templateFields;

    private FormDimensionUtils() {
    }

    public static boolean equals(FormSpec a, FormSpec b) {
        if (a.getClass() == b.getClass()) {
            return a.getDefaultAlignment() == b.getDefaultAlignment() && a.getResizeWeight() == b.getResizeWeight() && a.getSize().equals(b.getSize());
        }
        return false;
    }

    public static Field[] getTemplateFields() {
        if (m_templateFields == null) {
            List templateFieldsList = Lists.newArrayList();
            Field[] fields = FormSpecs.class.getFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) && FormSpec.class.isAssignableFrom(field.getType())) {
                    templateFieldsList.add(field);
                }
                ++i;
            }
            m_templateFields = templateFieldsList.toArray(new Field[templateFieldsList.size()]);
        }
        return m_templateFields;
    }

    public static Field getFormFactoryTemplate(final FormSpec o) {
        return (Field)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Field>(){

            public Field runObject() throws Exception {
                Field[] templateFields = FormDimensionUtils.getTemplateFields();
                int i = 0;
                while (i < templateFields.length) {
                    Field field = templateFields[i];
                    if (FormDimensionUtils.equals((FormSpec)field.get(null), o)) {
                        return field;
                    }
                    ++i;
                }
                return null;
            }
        });
    }
}

