/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core;

import com.google.common.base.Preconditions;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.handlers.ResetSendModeHandler;
import org.eclipse.epp.logging.aeri.core.handlers.SetSendModeHandler;
import org.eclipse.epp.logging.aeri.core.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jdt.annotation.Nullable;

public class SystemControl {
    private static IEclipseContext SYSTEM_CONTEXT;

    public static IEclipseContext getSystemContext() {
        if (SYSTEM_CONTEXT == null) {
            SYSTEM_CONTEXT = new EclipseContext(null);
            SYSTEM_CONTEXT.set("debugString", (Object)"AERI System Context");
            SYSTEM_CONTEXT.set(ISystemSettings.class, (Object)IModelFactory.eINSTANCE.createSystemSettings());
            SystemControl.registerHandlers(SetSendModeHandler.class, ResetSendModeHandler.class);
        }
        return SYSTEM_CONTEXT;
    }

    public static ISystemSettings getSystemSettings() {
        return (ISystemSettings)Preconditions.checkNotNull((Object)SystemControl.get(ISystemSettings.class));
    }

    @Nullable
    public static <T> T get(String key) {
        return (T)SystemControl.getSystemContext().get(key);
    }

    @Nullable
    public static <T> T get(Class<T> key) {
        return (T)SystemControl.getSystemContext().get(key);
    }

    public static boolean isActive() {
        block6: {
            try {
                if (!Boolean.getBoolean("org.eclipse.epp.logging.aeri.skipReports") && !Boolean.getBoolean("org.eclipse.epp.logging.aeri.ui.skipReports")) break block6;
                return false;
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_AERI_FAILURE, e, e.getMessage());
                return false;
            }
        }
        SendMode mode = (SendMode)((Object)SystemControl.executeHandler(ResetSendModeHandler.class));
        switch (mode) {
            case NEVER: {
                return false;
            }
        }
        return true;
    }

    public static boolean isDebug() {
        return SystemControl.getSystemSettings().isDebugEnabled();
    }

    public static void registerHandlers(Class<?> ... handlers) {
        Class<?>[] classArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            Object handler = ContextInjectionFactory.make(clazz, (IEclipseContext)SystemControl.getSystemContext());
            SystemControl.getSystemContext().declareModifiable(clazz);
            SystemControl.getSystemContext().set(clazz.getName(), handler);
            ++n2;
        }
    }

    @Nullable
    public static Object executeHandler(Class<?> clazz) {
        IEclipseContext context = SystemControl.getSystemContext();
        Object handler = context.get(clazz);
        return ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)context);
    }

    @Nullable
    public static Object executeHandler(Class<?> clazz, IEclipseContext localContext) {
        Object handler = SystemControl.getSystemContext().get(clazz);
        return ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)SystemControl.getSystemContext(), (IEclipseContext)localContext, null);
    }
}

