/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef DATABASE_H
#define DATABASE_H

#include <wx/colour.h>
#include <wx/font.h>
#include <wx/arrstr.h>
#include <wx/string.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/cmndata.h>
#include <wx/dynarray.h>

/*
    LabelStructure: Attributes a label object has

*/

class LabelStructure
{
    public:
        wxString L;             // Label
        int X, Y, Class, Align; // Position on x an y
        wxFontData Font;
        wxColourData Colour;
        double Angle;
        bool Bend;
};

/*
    ListStructure: Attributes a list object has

*/
class ListStructure
{
    public:
        int X, Y;
        wxArrayString L;
        wxFontData Font;
        wxColourData Colour;
};

/*
    ImageStructure: Attributes an image object has

*/
class ImageStructure
{
    public:
        int X, Y, Scale, Rotate;
        wxString Path;
        wxImage Img;
};

WX_DECLARE_OBJARRAY(LabelStructure, LabelA);
WX_DECLARE_OBJARRAY(ListStructure, ListA);
WX_DECLARE_OBJARRAY(ImageStructure, ImageA);

WX_DEFINE_ARRAY_INT(int, MyArrayInt);

/*
    DiscWrapperDatabase: Project data storaging class
    Everything in this class is saved in project files

*/
class DiscWrapperDatabase
{
    public:

        DiscWrapperDatabase();
        virtual ~DiscWrapperDatabase();



        int PDP, PDC;		// Number of pages, case type


        /*
            Each page has own data set, which includes
            all the information to be able to draw the design
        */
        typedef struct {
            wxBitmap PageBack, PrePageBack;   // Background images
            wxString PageBackPath;      // Paths of background images

            LabelA labels;
            ListA lists;
            ImageA images;

            MyArrayInt ImageOrder;


        } PageData;

        PageData Page[4];

};

#endif // DATABASE_H
