/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.loader.yahoo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import org.encog.app.quant.QuantTask;
import org.encog.app.quant.loader.LoaderError;
import org.encog.app.quant.loader.MarketLoader;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.http.FormUtility;
import org.encog.util.time.NumericDateUtil;

public class YahooDownload
implements MarketLoader,
QuantTask {
    public static final String INDEX_DJIA = "^dji";
    public static final String INDEX_SP500 = "^gspc";
    public static final String INDEX_NASDAQ = "^ixic";
    private int precision;
    private boolean cancel;

    public YahooDownload() {
        this.setPercision(10);
    }

    private URL buildURL(String ticker, Date from, Date to) throws IOException {
        Calendar calendarFrom = Calendar.getInstance();
        calendarFrom.setTime(from);
        Calendar calendarTo = Calendar.getInstance();
        calendarTo.setTime(to);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FormUtility form = new FormUtility(os, null);
        form.add("s", ticker.toUpperCase());
        form.add("a", "" + calendarFrom.get(2));
        form.add("b", "" + calendarFrom.get(5));
        form.add("c", "" + calendarFrom.get(1));
        form.add("d", "" + calendarTo.get(2));
        form.add("e", "" + calendarTo.get(5));
        form.add("f", "" + calendarTo.get(1));
        form.add("g", "d");
        form.add("ignore", ".csv");
        ((OutputStream)os).close();
        String str = "http://ichart.finance.yahoo.com/table.csv?" + ((Object)os).toString();
        return new URL(str);
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void loadAllData(String ticker, File output, CSVFormat outputFormat, Date from, Date to) {
        try {
            URL url = this.buildURL(ticker, from, to);
            InputStream is = url.openStream();
            ReadCSV csv = new ReadCSV(is, true, CSVFormat.ENGLISH);
            PrintWriter tw = new PrintWriter(new FileWriter(output));
            tw.println("date,time,open price,high price,low price,close price,volume,adjusted price");
            while (csv.next() && !this.shouldStop()) {
                Date date = csv.getDate("date");
                double adjClose = csv.getDouble("adj close");
                double open = csv.getDouble("open");
                double close = csv.getDouble("close");
                double high = csv.getDouble("high");
                double low = csv.getDouble("low");
                double volume = csv.getDouble("volume");
                NumberFormat df = NumberFormat.getInstance();
                df.setGroupingUsed(false);
                StringBuilder line = new StringBuilder();
                line.append(NumericDateUtil.date2Long(date));
                line.append(outputFormat.getSeparator());
                line.append(NumericDateUtil.time2Int(date));
                line.append(outputFormat.getSeparator());
                line.append(outputFormat.format(open, this.precision));
                line.append(outputFormat.getSeparator());
                line.append(outputFormat.format(high, this.precision));
                line.append(outputFormat.getSeparator());
                line.append(outputFormat.format(low, this.precision));
                line.append(outputFormat.getSeparator());
                line.append(outputFormat.format(close, this.precision));
                line.append(outputFormat.getSeparator());
                line.append(df.format(volume));
                line.append(outputFormat.getSeparator());
                line.append(outputFormat.format(adjClose, this.precision));
                tw.println(line.toString());
            }
            tw.close();
        }
        catch (IOException ex) {
            throw new LoaderError(ex);
        }
    }

    @Override
    public final void requestStop() {
        this.cancel = true;
    }

    public final void setPercision(int thePrecision) {
        this.precision = thePrecision;
    }

    @Override
    public final boolean shouldStop() {
        return this.cancel;
    }
}

