/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer.codec;

import org.encog.ml.data.buffer.codec.DataSetCODEC;
import org.encog.util.EngineArray;

public class ArrayDataCODEC
implements DataSetCODEC {
    private int index;
    private int inputSize;
    private int idealSize;
    private double[][] input;
    private double[][] ideal;

    public ArrayDataCODEC(double[][] theInput, double[][] theIdeal) {
        this.input = theInput;
        this.ideal = theIdeal;
        this.inputSize = this.input[0].length;
        this.idealSize = this.ideal[0].length;
        this.index = 0;
    }

    public ArrayDataCODEC() {
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public boolean read(double[] theInput, double[] theIdeal, double[] significance) {
        if (this.index >= this.input.length) {
            return false;
        }
        EngineArray.arrayCopy(this.input[this.index], theInput);
        EngineArray.arrayCopy(this.ideal[this.index], theIdeal);
        significance[0] = 1.0;
        ++this.index;
        return true;
    }

    @Override
    public void write(double[] theInput, double[] theIdeal, double significance) {
        EngineArray.arrayCopy(theInput, this.input[this.index]);
        EngineArray.arrayCopy(theIdeal, this.ideal[this.index]);
        ++this.index;
    }

    @Override
    public void prepareWrite(int recordCount, int theInputSize, int theIdealSize) {
        this.input = new double[recordCount][theInputSize];
        this.ideal = new double[recordCount][theIdealSize];
        this.inputSize = theInputSize;
        this.idealSize = theIdealSize;
        this.index = 0;
    }

    public double[][] getInput() {
        return this.input;
    }

    public double[][] getIdeal() {
        return this.ideal;
    }

    @Override
    public void prepareRead() {
    }

    @Override
    public void close() {
    }
}

