/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.species;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.sort.SortGenomesForSpecies;
import org.encog.ml.ea.sort.SpeciesComparator;
import org.encog.ml.ea.species.BasicSpecies;
import org.encog.ml.ea.species.Speciation;
import org.encog.ml.ea.species.Species;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.genetic.GeneticError;

public abstract class ThresholdSpeciation
implements Speciation,
Serializable {
    private static final long serialVersionUID = 1L;
    private EvolutionaryAlgorithm owner;
    private double compatibilityThreshold = 1.0;
    private int numGensAllowedNoImprovement = 15;
    private int maxNumberOfSpecies = 40;
    private SortGenomesForSpecies sortGenomes;
    private Population population;

    public void addSpeciesMember(Species species, Genome genome) {
        if (this.owner.isValidationMode() && species.getMembers().contains(genome)) {
            throw new GeneticError("Species already contains genome: " + genome.toString());
        }
        if (this.owner.getSelectionComparator().compare(genome, species.getLeader()) < 0) {
            species.setBestScore(genome.getAdjustedScore());
            species.setGensNoImprovement(0);
            species.setLeader(genome);
        }
        species.add(genome);
    }

    private void adjustCompatibilityThreshold() {
        if (this.maxNumberOfSpecies < 1) {
            return;
        }
        double thresholdIncrement = 0.01;
        if (this.population.getSpecies().size() > this.maxNumberOfSpecies) {
            this.compatibilityThreshold += 0.01;
        } else if (this.population.getSpecies().size() < 2) {
            this.compatibilityThreshold -= 0.01;
        }
    }

    private void divideByFittestSpecies(List<Species> speciesCollection, double totalSpeciesScore) {
        Object[] speciesArray;
        Species bestSpecies = this.findBestSpecies();
        for (Object element : speciesArray = speciesCollection.toArray()) {
            Species species = (Species)element;
            int share = (int)Math.round(species.getOffspringShare() / totalSpeciesScore * (double)this.owner.getPopulation().getPopulationSize());
            if (species == bestSpecies && share == 0) {
                share = 1;
            }
            if (species.getMembers().size() == 0 || share == 0) {
                this.removeSpecies(species);
                continue;
            }
            if (species.getGensNoImprovement() > this.numGensAllowedNoImprovement && species != bestSpecies) {
                this.removeSpecies(species);
                continue;
            }
            species.setOffspringCount(share);
            Collections.sort(species.getMembers(), this.sortGenomes);
        }
    }

    public Species findBestSpecies() {
        if (this.owner.getBestGenome() != null) {
            return this.owner.getBestGenome().getSpecies();
        }
        return null;
    }

    public void removeSpecies(Species species) {
        if (species != this.findBestSpecies() && this.population.getSpecies().size() > 1) {
            this.population.getSpecies().remove(species);
        }
    }

    private void divideEven(List<Species> speciesCollection) {
        double ratio = 1.0 / (double)speciesCollection.size();
        for (Species species : speciesCollection) {
            int share = (int)Math.round(ratio * (double)this.owner.getPopulation().getPopulationSize());
            species.setOffspringCount(share);
        }
    }

    public double getCompatibilityThreshold() {
        return this.compatibilityThreshold;
    }

    public int getMaxNumberOfSpecies() {
        return this.maxNumberOfSpecies;
    }

    public int getNumGensAllowedNoImprovement() {
        return this.numGensAllowedNoImprovement;
    }

    public EvolutionaryAlgorithm getOwner() {
        return this.owner;
    }

    public SortGenomesForSpecies getSortGenomes() {
        return this.sortGenomes;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
        this.population = theOwner.getPopulation();
        this.sortGenomes = new SortGenomesForSpecies(this.owner);
    }

    private void levelOff() {
        int total = 0;
        List<Species> list = this.population.getSpecies();
        if (list.size() == 0) {
            throw new EncogError("Can't speciate, next generation contains no species.");
        }
        Collections.sort(list, new SpeciesComparator(this.owner));
        if (list.get(0).getOffspringCount() == 0) {
            list.get(0).setOffspringCount(1);
        }
        for (Species species : list) {
            total += species.getOffspringCount();
        }
        int diff = this.population.getPopulationSize() - total;
        if (diff < 0) {
            int t;
            for (int index = list.size() - 1; diff != 0 && index > 0; diff += t, --index) {
                Species species = list.get(index);
                t = Math.min(species.getOffspringCount(), Math.abs(diff));
                species.setOffspringCount(species.getOffspringCount() - t);
                if (species.getOffspringCount() != 0) continue;
                list.remove(index);
            }
        } else {
            list.get(0).setOffspringCount(list.get(0).getOffspringCount() + diff);
        }
    }

    @Override
    public void performSpeciation(List<Genome> genomeList) {
        List<Genome> newGenomeList = this.resetSpecies(genomeList);
        this.speciateAndCalculateSpawnLevels(newGenomeList);
    }

    private List<Genome> resetSpecies(List<Genome> inputGenomes) {
        ArrayList<Genome> result = new ArrayList<Genome>();
        Object[] speciesArray = this.population.getSpecies().toArray();
        for (Genome genome : inputGenomes) {
            result.add(genome);
        }
        for (Object element : speciesArray) {
            BasicSpecies s = (BasicSpecies)element;
            s.purge();
            if (!inputGenomes.contains(s.getLeader())) {
                this.removeSpecies(s);
            } else if (s.getGensNoImprovement() > this.numGensAllowedNoImprovement) {
                this.removeSpecies(s);
            }
            result.remove(s.getLeader());
        }
        if (this.population.getSpecies().size() == 0) {
            throw new EncogError("Can't speciate, the population is empty.");
        }
        return result;
    }

    public void setCompatibilityThreshold(double compatibilityThreshold) {
        this.compatibilityThreshold = compatibilityThreshold;
    }

    public void setMaxNumberOfSpecies(int maxNumberOfSpecies) {
        this.maxNumberOfSpecies = maxNumberOfSpecies;
    }

    public void setNumGensAllowedNoImprovement(int numGensAllowedNoImprovement) {
        this.numGensAllowedNoImprovement = numGensAllowedNoImprovement;
    }

    public void setSortGenomes(SortGenomesForSpecies sortGenomes) {
        this.sortGenomes = sortGenomes;
    }

    private void speciateAndCalculateSpawnLevels(List<Genome> genomes) {
        double maxScore = 0.0;
        if (genomes.size() == 0) {
            throw new EncogError("Can't speciate, the population is empty.");
        }
        List<Species> speciesCollection = this.population.getSpecies();
        if (speciesCollection.size() == 0) {
            throw new EncogError("Can't speciate, there are no species.1");
        }
        this.adjustCompatibilityThreshold();
        for (Genome g : genomes) {
            Species currentSpecies = null;
            Genome genome = g;
            if (!Double.isNaN(genome.getAdjustedScore()) && !Double.isInfinite(genome.getAdjustedScore())) {
                maxScore = Math.max(genome.getAdjustedScore(), maxScore);
            }
            for (Species s : speciesCollection) {
                double compatibility = this.getCompatibilityScore(genome, s.getLeader());
                if (!(compatibility <= this.compatibilityThreshold)) continue;
                currentSpecies = s;
                this.addSpeciesMember(s, genome);
                genome.setSpecies(s);
                break;
            }
            if (currentSpecies != null) continue;
            currentSpecies = new BasicSpecies(this.population, genome);
            this.population.getSpecies().add(currentSpecies);
        }
        double totalSpeciesScore = 0.0;
        for (Species species : speciesCollection) {
            totalSpeciesScore += species.calculateShare(this.owner.getScoreFunction().shouldMinimize(), maxScore);
        }
        if (speciesCollection.size() == 0) {
            throw new EncogError("Can't speciate, there are no species.2");
        }
        if (totalSpeciesScore < 1.0E-13) {
            this.divideEven(speciesCollection);
        } else {
            this.divideByFittestSpecies(speciesCollection, totalSpeciesScore);
        }
        this.levelOff();
    }

    public abstract double getCompatibilityScore(Genome var1, Genome var2);
}

