/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.method;

import java.util.Map;
import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.MLActivationFactory;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.neural.neat.NEATPopulation;
import org.encog.util.ParamsHolder;

public class NEATFactory {
    private MLActivationFactory factory = new MLActivationFactory();

    public MLMethod create(String architecture, int input, int output) {
        if (input <= 0) {
            throw new EncogError("Must have at least one input for NEAT.");
        }
        if (output <= 0) {
            throw new EncogError("Must have at least one output for NEAT.");
        }
        Map<String, String> args = ArchitectureParse.parseParams(architecture);
        ParamsHolder holder = new ParamsHolder(args);
        int populationSize = holder.getInt("population", false, 1000);
        int cycles = holder.getInt("cycles", false, 4);
        ActivationFunction af = this.factory.create(holder.getString("AF", false, "ssigmoid"));
        NEATPopulation pop = new NEATPopulation(input, output, populationSize);
        pop.reset();
        pop.setActivationCycles(cycles);
        pop.setNEATActivationFunction(af);
        return pop;
    }
}

