/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.method;

import java.util.List;
import org.encog.EncogError;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.parse.ArchitectureLayer;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.neural.rbf.RBFNetwork;

public class SRNFactory {
    public static final int MAX_LAYERS = 3;

    public MLMethod create(String architecture, int input, int output) {
        List<String> layers = ArchitectureParse.parseLayers(architecture);
        if (layers.size() != 3) {
            throw new EncogError("SRN Networks must have exactly three elements, separated by ->.");
        }
        ArchitectureLayer inputLayer = ArchitectureParse.parseLayer(layers.get(0), input);
        ArchitectureLayer rbfLayer = ArchitectureParse.parseLayer(layers.get(1), -1);
        ArchitectureLayer outputLayer = ArchitectureParse.parseLayer(layers.get(2), output);
        int inputCount = inputLayer.getCount();
        int outputCount = outputLayer.getCount();
        RBFEnum t = rbfLayer.getName().equalsIgnoreCase("Gaussian") ? RBFEnum.Gaussian : (rbfLayer.getName().equalsIgnoreCase("Multiquadric") ? RBFEnum.Multiquadric : (rbfLayer.getName().equalsIgnoreCase("InverseMultiquadric") ? RBFEnum.InverseMultiquadric : (rbfLayer.getName().equalsIgnoreCase("MexicanHat") ? RBFEnum.MexicanHat : RBFEnum.Gaussian)));
        RBFNetwork result = new RBFNetwork(inputCount, rbfLayer.getCount(), outputCount, t);
        return result;
    }
}

