/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.FunctionFactory;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.util.csv.CSVFormat;

public class EncogProgramContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CSVFormat format;
    private final FunctionFactory functions;
    private final List<VariableMapping> definedVariables = new ArrayList<VariableMapping>();
    private final Map<String, VariableMapping> map = new HashMap<String, VariableMapping>();
    private VariableMapping result = new VariableMapping(null, ValueType.floatingType);

    public EncogProgramContext() {
        this(CSVFormat.ENGLISH, new FunctionFactory());
    }

    public EncogProgramContext(CSVFormat format) {
        this(format, new FunctionFactory());
    }

    public EncogProgramContext(CSVFormat theFormat, FunctionFactory theFunctions) {
        this.format = theFormat;
        this.functions = theFunctions;
    }

    public void clearDefinedVariables() {
        this.definedVariables.clear();
        this.map.clear();
    }

    public ProgramNode cloneBranch(EncogProgram targetProgram, ProgramNode sourceBranch) {
        if (sourceBranch == null) {
            throw new EncogError("Can't clone null branch.");
        }
        String name = sourceBranch.getName();
        ProgramNode[] args = new ProgramNode[sourceBranch.getChildNodes().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.cloneBranch(targetProgram, (ProgramNode)sourceBranch.getChildNodes().get(i));
        }
        ProgramNode result = targetProgram.getContext().getFunctions().factorProgramNode(name, targetProgram, args);
        for (int i = 0; i < sourceBranch.getData().length; ++i) {
            result.getData()[i] = new ExpressionValue(sourceBranch.getData()[i]);
        }
        return result;
    }

    public EncogProgram cloneProgram(EncogProgram sourceProgram) {
        ProgramNode rootNode = sourceProgram.getRootNode();
        EncogProgram result = new EncogProgram(this);
        result.setRootNode(this.cloneBranch(result, rootNode));
        return result;
    }

    public EncogProgram createProgram(String expression) {
        EncogProgram result = new EncogProgram(this);
        result.compileExpression(expression);
        return result;
    }

    public void defineVariable(String theName) {
        this.defineVariable(theName, ValueType.floatingType, 0, 0);
    }

    public void defineVariable(String theName, ValueType theVariableType) {
        this.defineVariable(theName, theVariableType, 0, 0);
    }

    public void defineVariable(String theName, ValueType theVariableType, int theEnumType, int theEnumValueCount) {
        VariableMapping mapping = new VariableMapping(theName, theVariableType, theEnumType, theEnumValueCount);
        this.defineVariable(mapping);
    }

    public void defineVariable(VariableMapping mapping) {
        if (this.map.containsKey(mapping.getName())) {
            throw new EARuntimeError("Variable " + mapping.getName() + " already defined.");
        }
        this.map.put(mapping.getName(), mapping);
        this.definedVariables.add(mapping);
    }

    public List<VariableMapping> findVariablesByTypes(List<ValueType> desiredTypes) {
        ArrayList<VariableMapping> result = new ArrayList<VariableMapping>();
        for (VariableMapping mapping : this.definedVariables) {
            if (!desiredTypes.contains((Object)mapping.getVariableType())) continue;
            result.add(mapping);
        }
        return result;
    }

    public List<VariableMapping> getDefinedVariables() {
        return this.definedVariables;
    }

    public int getEnumCount(int enumType) {
        if (this.result.getVariableType() == ValueType.enumType && this.result.getEnumType() == enumType) {
            return this.result.getEnumValueCount();
        }
        for (VariableMapping mapping : this.definedVariables) {
            if (mapping.getVariableType() != ValueType.enumType || mapping.getEnumType() != enumType) continue;
            return mapping.getEnumValueCount();
        }
        throw new EARuntimeError("Undefined enum type: " + enumType);
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public FunctionFactory getFunctions() {
        return this.functions;
    }

    public int getMaxEnumType() {
        int r = -1;
        if (this.result.getVariableType() == ValueType.enumType) {
            r = this.result.getEnumType();
        }
        for (VariableMapping mapping : this.definedVariables) {
            if (mapping.getVariableType() != ValueType.enumType) continue;
            r = Math.max(r, mapping.getEnumType());
        }
        if (r == -1) {
            throw new EARuntimeError("No enum types defined in context.");
        }
        return r;
    }

    public VariableMapping getResult() {
        return this.result;
    }

    public boolean hasEnum() {
        if (this.result.getVariableType() == ValueType.enumType) {
            return true;
        }
        for (VariableMapping mapping : this.definedVariables) {
            if (mapping.getVariableType() != ValueType.enumType) continue;
            return true;
        }
        return false;
    }

    public void loadAllFunctions() {
        StandardExtensions.createAll(this);
    }

    public void setResult(VariableMapping result) {
        this.result = result;
    }
}

