/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.opp;

import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.ml.tree.TreeNode;

public class ConstMutation
implements EvolutionaryOperator {
    private final double frequency;
    private final double sigma;

    public ConstMutation(EncogProgramContext theContext, double theFrequency, double theSigma) {
        this.frequency = theFrequency;
        this.sigma = theSigma;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
    }

    private void mutateNode(Random rnd, ProgramNode node) {
        ExpressionValue v;
        if (node.getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT && rnd.nextDouble() < this.frequency && (v = node.getData()[0]).isFloat()) {
            double adj = rnd.nextGaussian() * this.sigma;
            node.getData()[0] = new ExpressionValue(v.toFloatValue() + adj);
        }
        for (TreeNode n : node.getChildNodes()) {
            ProgramNode childNode = (ProgramNode)n;
            this.mutateNode(rnd, childNode);
        }
    }

    @Override
    public int offspringProduced() {
        return 1;
    }

    @Override
    public int parentsNeeded() {
        return 1;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        EncogProgram program = (EncogProgram)parents[0];
        EncogProgramContext context = program.getContext();
        EncogProgram result = context.cloneProgram(program);
        this.mutateNode(rnd, result.getRootNode());
        offspring[0] = result;
    }
}

