/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy.end;

import org.encog.ml.MLError;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;

public class EarlyStoppingStrategy
implements EndTrainingStrategy {
    private MLDataSet validationSet;
    private MLDataSet testSet;
    private MLTrain train;
    private boolean stop;
    private double trainingError;
    private double testError;
    private double validationError;
    private MLError calc;
    private double eOpt;
    private double gl;
    private double alpha;
    private int lastCheck;
    private int stripLength;
    private double stripOpt;
    private double stripTotal;
    private double stripEfficiency;
    private double minEfficiency;

    public EarlyStoppingStrategy(MLDataSet theValidationSet, MLDataSet theTestSet) {
        this(theValidationSet, theTestSet, 5, 5.0, 0.1);
    }

    public EarlyStoppingStrategy(MLDataSet theValidationSet, MLDataSet theTestSet, int theStripLength, double theAlpha, double theMinEfficiency) {
        this.validationSet = theValidationSet;
        this.testSet = theTestSet;
        this.alpha = theAlpha;
        this.stripLength = theStripLength;
        this.minEfficiency = theMinEfficiency;
    }

    @Override
    public void init(MLTrain theTrain) {
        this.train = theTrain;
        this.calc = (MLError)this.train.getMethod();
        this.eOpt = Double.POSITIVE_INFINITY;
        this.stripOpt = Double.POSITIVE_INFINITY;
        this.stop = false;
        this.lastCheck = 0;
    }

    @Override
    public void preIteration() {
    }

    @Override
    public void postIteration() {
        ++this.lastCheck;
        this.trainingError = this.train.getError();
        this.stripOpt = Math.min(this.stripOpt, this.trainingError);
        this.stripTotal += this.trainingError;
        if (this.lastCheck > this.stripLength) {
            this.validationError = this.calc.calculateError(this.validationSet);
            this.testError = this.calc.calculateError(this.testSet);
            this.eOpt = Math.min(this.validationError, this.eOpt);
            this.gl = 100.0 * (this.validationError / this.eOpt - 1.0);
            this.stripEfficiency = this.stripTotal / ((double)this.stripLength * this.stripOpt);
            this.stripTotal = 0.0;
            this.lastCheck = 0;
            this.stop = this.gl > this.alpha || this.stripEfficiency < this.minEfficiency;
        }
    }

    @Override
    public boolean shouldStop() {
        return this.stop;
    }

    public double getTrainingError() {
        return this.trainingError;
    }

    public double getTestError() {
        return this.testError;
    }

    public double getValidationError() {
        return this.validationError;
    }

    public double geteOpt() {
        return this.eOpt;
    }

    public double getGl() {
        return this.gl;
    }

    public int getStripLength() {
        return this.stripLength;
    }

    public double getStripOpt() {
        return this.stripOpt;
    }

    public double getStripEfficiency() {
        return this.stripEfficiency;
    }

    public double getMinEfficiency() {
        return this.minEfficiency;
    }
}

