/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.concurrency.job;

import org.encog.StatusReportable;
import org.encog.util.concurrency.EngineConcurrency;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.concurrency.TaskGroup;
import org.encog.util.concurrency.job.JobUnitContext;
import org.encog.util.concurrency.job.JobUnitWorker;

public abstract class ConcurrentJob
implements Runnable,
MultiThreadable {
    private int threadCount;
    private StatusReportable report;
    private int totalTasks;
    private int current;
    private boolean shouldStop = false;
    private boolean running;

    public ConcurrentJob(StatusReportable report) {
        this.report = report;
        this.current = 1;
    }

    public abstract int loadWorkload();

    public abstract void performJobUnit(JobUnitContext var1);

    public void process() {
        Object task;
        EngineConcurrency.getInstance().setThreadCount(this.threadCount);
        this.running = true;
        this.totalTasks = this.loadWorkload();
        int currentTask = 0;
        TaskGroup group = EngineConcurrency.getInstance().createTaskGroup();
        while ((task = this.requestNextTask()) != null && !this.shouldStop) {
            JobUnitContext context = new JobUnitContext();
            context.setJobUnit(task);
            context.setOwner(this);
            context.setTaskNumber(++currentTask);
            JobUnitWorker worker = new JobUnitWorker(context);
            EngineConcurrency.getInstance().processTask(worker, group);
        }
        group.waitForComplete();
        this.running = false;
        EngineConcurrency.getInstance().checkError();
    }

    public void processBackground() {
        Thread t = new Thread(this);
        t.start();
    }

    public void reportStatus(JobUnitContext context, String status) {
        this.report.report(this.totalTasks, this.current++, status);
    }

    public abstract Object requestNextTask();

    public boolean getShouldStop() {
        return this.shouldStop;
    }

    public void stop() {
        this.shouldStop = true;
    }

    @Override
    public void run() {
        this.process();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setReport(StatusReportable r) {
        this.report = r;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threadCount = numThreads;
    }
}

