/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.QuaquaComboBoxVisualMargin;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.AlphaColorUIResource;
import ch.randelshofer.quaqua.util.InactivatableColorUIResource;
import ch.randelshofer.quaqua.util.Preferences;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

public class BasicQuaquaLookAndFeel
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String pantherDir = "/ch/randelshofer/quaqua/panther/images/";
    protected static final String tigerDir = "/ch/randelshofer/quaqua/tiger/images/";
    private static final int[][] selectionColors = new int[][]{{-3682085, 7835048}, {-3750202, 0x7F7F7F}, {-4860417, 3700183}, {-266893, 0xFFC11F}, {-20084, 15943240}, {-11647, 16747042}, {-3933807, 6735175}, {-1459969, 9195192}};

    public BasicQuaquaLookAndFeel(String targetClassName) {
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    public String getID() {
        return "Aqua";
    }

    public UIDefaults getDefaults() {
        UIDefaults table = this.target.getDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        if (QuaquaManager.getProperty("Quaqua.TextComponent.autoSelect", "true").equals("true")) {
            this.installKeyboardFocusManager();
        }
        return table;
    }

    protected final void initComponentDefaults(UIDefaults table) {
        this.initResourceBundle(table);
        this.initColorDefaults(table);
        this.initInputMapDefaults(table);
        this.initFontDefaults(table);
        this.initGeneralDefaults(table);
        this.initDesignDefaults(table);
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels");
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        ColorUIResource listSelectionBackground;
        ColorUIResource listSelectionForeground;
        ColorUIResource textSelectionBackground;
        ColorUIResource inactiveSelectionBackground = new ColorUIResource(0xD0D0D0);
        String colorValues = Preferences.getString("AppleHighlightColor");
        try {
            float[] rgb = new float[3];
            StringTokenizer tt = new StringTokenizer(colorValues);
            for (int i = 0; i < 3; ++i) {
                String value = tt.nextToken();
                rgb[i] = Float.valueOf(value).floatValue();
            }
            textSelectionBackground = new ColorUIResource(rgb[0], rgb[1], rgb[2]);
        }
        catch (Exception e) {
            textSelectionBackground = new ColorUIResource(-4860417);
        }
        ColorUIResource listSelectionBorderColor = new ColorUIResource(0x808080);
        if (QuaquaManager.getProperty("Quaqua.selectionStyle", "auto").equals("bright")) {
            listSelectionForeground = new ColorUIResource(0);
            listSelectionBackground = textSelectionBackground;
        } else {
            listSelectionForeground = new ColorUIResource(0xFFFFFF);
            int textSelectionRGB = textSelectionBackground.getRGB() | 0xFF000000;
            listSelectionBackground = null;
            for (int i = 0; i < selectionColors.length; ++i) {
                if (selectionColors[i][0] != textSelectionRGB) continue;
                listSelectionBackground = new ColorUIResource(selectionColors[i][1]);
                break;
            }
            if (listSelectionBackground == null) {
                float[] hsb = Color.RGBtoHSB(textSelectionBackground.getRed(), textSelectionBackground.getGreen(), textSelectionBackground.getBlue(), null);
                listSelectionBackground = new ColorUIResource(Color.getHSBColor(hsb[0], hsb[1], hsb[2] * 0.8f));
            }
        }
        boolean isGraphite = Preferences.getString("AppleAquaColorVariant").equals("6");
        Object[] objects = new Object[]{"desktop", new ColorUIResource(isGraphite ? 6582661 : 3828138), "activeCaption", table.get("InternalFrame.activeTitleBackground"), "activeCaptionText", new ColorUIResource(0), "activeCaptionBorder", table.get("InternalFrame.borderColor"), "inactiveCaption", table.get("InternalFrame.inactiveTitleBackground"), "inactiveCaptionText", new ColorUIResource(0x666666), "inactiveCaptionBorder", table.get("InternalFrame.borderColor"), "window", table.get("control"), "windowBorder", table.get("control"), "windowText", new ColorUIResource(0), "menu", table.get("MenuItem.background"), "menuText", new ColorUIResource(0), "text", new ColorUIResource(0xFFFFFF), "textText", new ColorUIResource(0), "textHighlight", textSelectionBackground, "textHighlightText", new ColorUIResource(0), "textInactiveText", new ColorUIResource(0x808080), "control", table.get("control"), "controlText", new ColorUIResource(0), "controlHighlight", new ColorUIResource(0xC0C0C0), "controlLtHighlight", new ColorUIResource(0xFFFFFF), "controlShadow", new ColorUIResource(0x808080), "controlDkShadow", new ColorUIResource(0), "scrollbar", table.get("control"), "info", new ColorUIResource(0xFFFFC1), "infoText", new ColorUIResource(0), "list", new ColorUIResource(0xFFFFFF), "listText", new ColorUIResource(0), "listHighlight", listSelectionBackground, "listHighlightText", listSelectionForeground, "listHighlightBorder", listSelectionBorderColor, "listInactiveHighlight", inactiveSelectionBackground, "listInactiveText", new ColorUIResource(0x808080), "menuHighlightText", new ColorUIResource(0xFFFFFF), "menuHighlight", table.get("Menu.selectionBackground")};
        table.putDefaults(objects);
    }

    protected void initColorDefaults(UIDefaults table) {
        Object controlForeground = table.get("controlText");
        Object controlBackground = table.get("control");
        Object textBackground = table.get("text");
        Object textForeground = table.get("textText");
        Object textSelectionBackground = table.get("textHighlight");
        AlphaColorUIResource translucentColor = new AlphaColorUIResource(0);
        Object disabledForeground = table.get("textInactiveText");
        ColorUIResource inactiveSelectionBackground = new ColorUIResource(208, 208, 208);
        Object inactiveSelectionForeground = controlForeground;
        Object menuBackground = table.get("menu");
        Object menuForeground = table.get("menuText");
        Object menuSelectionForeground = table.get("menuHighlightText");
        Object menuSelectionBackground = table.get("menuHighlight");
        Object menuDisabledBackground = menuBackground;
        Object menuDisabledForeground = disabledForeground;
        Object listBackground = table.get("list");
        Object listForeground = table.get("listText");
        InactivatableColorUIResource listSelectionBackground = new InactivatableColorUIResource(((Color)table.get("listHighlight")).getRGB(), inactiveSelectionBackground.getRGB());
        InactivatableColorUIResource listSelectionForeground = new InactivatableColorUIResource(((Color)table.get("listHighlightText")).getRGB(), ((Color)inactiveSelectionForeground).getRGB());
        ColorUIResource listSelectionBorderColor = (ColorUIResource)table.get("listHighlightBorder");
        ColorUIResource listAlternateBackground = Preferences.get("AppleAquaColorVariant").equals("6") ? new ColorUIResource(0xF0F0F0) : new ColorUIResource(15594494);
        Object[] objects = new Object[]{"Browser.selectionBackground", listSelectionBackground, "Browser.selectionForeground", listSelectionForeground, "Browser.selectionBorderColor", listSelectionBorderColor, "Browser.inactiveSelectionBackground", inactiveSelectionBackground, "Browser.inactiveSelectionForeground", inactiveSelectionForeground, "Button.background", controlBackground, "Button.foreground", controlForeground, "Button.disabledForeground", disabledForeground, "CheckBox.background", controlBackground, "CheckBox.foreground", controlForeground, "CheckBox.disabledForeground", disabledForeground, "CheckBoxMenuItem.background", menuBackground, "CheckBoxMenuItem.foreground", menuForeground, "CheckBoxMenuItem.selectionForeground", menuSelectionForeground, "CheckBoxMenuItem.selectionBackground", menuSelectionBackground, "CheckBoxMenuItem.disabledForeground", disabledForeground, "CheckBoxMenuItem.acceleratorForeground", menuForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", menuSelectionForeground, "ColorChooser.background", controlBackground, "ColorChooser.foreground", controlForeground, "ColorChooser.listSelectionBackground", new ColorUIResource(0xD4D4D4), "ColorChooser.listSelectionForeground", new ColorUIResource(0), "ComboBox.background", controlBackground, "ComboBox.foreground", controlForeground, "ComboBox.disabledBackground", controlBackground, "ComboBox.disabledForeground", disabledForeground, "ComboBox.selectionBackground", menuSelectionBackground, "ComboBox.selectionForeground", menuSelectionForeground, "Dialog.background", controlBackground, "Dialog.foreground", controlForeground, "Desktop.background", table.get("desktop"), "EditorPane.background", textBackground, "EditorPane.caretForeground", textForeground, "EditorPane.foreground", textForeground, "EditorPane.inactiveBackground", textBackground, "EditorPane.inactiveForeground", disabledForeground, "EditorPane.selectionBackground", textSelectionBackground, "EditorPane.selectionForeground", textForeground, "FileChooser.previewLabelForeground", textForeground, "FileChooser.previewValueForeground", textForeground, "FormattedTextField.background", textBackground, "FormattedTextField.foreground", textForeground, "FormattedTextField.inactiveBackground", textBackground, "FormattedTextField.inactiveForeground", disabledForeground, "FormattedTextField.selectionBackground", textSelectionBackground, "FormattedTextField.selectionForeground", textForeground, "InternalFrame.small.titlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.small.paletteTitleBar.png"), "InternalFrame.small.vTitlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.small.vPaletteTitleBar.png"), "InternalFrame.small.titlePane.foreground", controlForeground, "InternalFrame.small.titlePane.shadow", new ColorUIResource(0x8E8E8E), "InternalFrame.small.closeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.small.closeIcons.png", 12), "InternalFrame.small.maximizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.small.maximizeIcons.png", 12), "InternalFrame.small.minimizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.small.maximizeIcons.png", 12), "InternalFrame.small.iconifyIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.small.iconifyIcons.png", 12), "InternalFrame.titlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.paletteTitleBar.png"), "InternalFrame.vTitlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.vPaletteTitleBar.png"), "InternalFrame.titlePane.foreground", controlForeground, "InternalFrame.titlePane.shadow", new ColorUIResource(0x8E8E8E), "InternalFrame.closeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.closeIcons.png", 12), "InternalFrame.maximizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.maximizeIcons.png", 12), "InternalFrame.minimizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.maximizeIcons.png", 12), "InternalFrame.iconifyIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.iconifyIcons.png", 12), "InternalFrame.mini.titlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.mini.paletteTitleBar.png"), "InternalFrame.mini.vTitlePane.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.mini.vPaletteTitleBar.png"), "InternalFrame.mini.titlePane.foreground", controlForeground, "InternalFrame.mini.titlePane.shadow", new ColorUIResource(0x8E8E8E), "InternalFrame.mini.closeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.mini.closeIcons.png", 12), "InternalFrame.mini.maximizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.mini.maximizeIcons.png", 12), "InternalFrame.mini.minimizeIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.mini.maximizeIcons.png", 12), "InternalFrame.mini.iconifyIcon", BasicQuaquaLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.mini.iconifyIcons.png", 12), "InternalFrame.resizeIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Frame.resize.png"), "Label.background", controlBackground, "Label.foreground", controlForeground, "Label.disabledForeground", disabledForeground, "List.alternateBackground.0", listAlternateBackground, "List.alternateBackground.1", listBackground, "List.background", textBackground, "List.foreground", controlForeground, "List.selectionBackground", listSelectionBackground, "List.selectionForeground", listSelectionForeground, "Menu.background", menuBackground, "Menu.foreground", menuForeground, "Menu.acceleratorForeground", menuForeground, "Menu.acceleratorSelectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.disabledBackground", menuDisabledBackground, "Menu.disabledForeground", menuDisabledForeground, "MenuBar.background", menuBackground, "MenuBar.foreground", menuForeground, "MenuItem.background", menuBackground, "MenuItem.foreground", menuForeground, "MenuItem.acceleratorForeground", menuForeground, "MenuItem.acceleratorSelectionForeground", menuSelectionForeground, "MenuItem.selectionBackground", menuSelectionBackground, "MenuItem.selectionForeground", menuSelectionForeground, "MenuItem.disabledBackground", menuDisabledBackground, "MenuItem.disabledForeground", menuDisabledForeground, "MenuSeparator.background", menuBackground, "OptionPane.background", controlBackground, "OptionPane.foreground", controlForeground, "OptionPane.messageForeground", controlForeground, "Panel.background", controlBackground, "Panel.foreground", controlForeground, "PasswordField.background", textBackground, "PasswordField.foreground", textForeground, "PasswordField.caretForeground", textForeground, "PasswordField.inactiveBackground", textBackground, "PasswordField.inactiveForeground", disabledForeground, "PasswordField.selectionBackground", textSelectionBackground, "PasswordField.selectionForeground", textForeground, "PopupMenu.foreground", menuForeground, "PopupMenu.background", menuBackground, "PopupMenu.selectionBackground", menuSelectionBackground, "RadioButton.disabledForeground", disabledForeground, "RadioButton.background", controlBackground, "RadioButton.foreground", controlForeground, "RadioButtonMenuItem.foreground", controlForeground, "RadioButtonMenuItem.selectionForeground", menuSelectionForeground, "RadioButtonMenuItem.background", menuBackground, "RadioButtonMenuItem.foreground", menuForeground, "RadioButtonMenuItem.acceleratorForeground", menuForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", menuSelectionForeground, "RadioButtonMenuItem.selectionBackground", menuSelectionBackground, "RadioButtonMenuItem.selectionForeground", menuSelectionForeground, "RadioButtonMenuItem.disabledBackground", menuDisabledBackground, "RadioButtonMenuItem.disabledForeground", menuDisabledForeground, "RootPane.background", controlBackground, "ScrollBar.background", controlBackground, "ScrollBar.foreground", controlForeground, "ScrollPane.background", controlBackground, "ScrollPane.foreground", controlForeground, "Separator.background", controlBackground, "Separator.foreground", new ColorUIResource(0x808080), "Separator.highlight", new ColorUIResource(0xE0E0E0), "Separator.shadow", new ColorUIResource(0x808080), "Slider.background", controlBackground, "Slider.foreground", controlForeground, "Spinner.background", textBackground, "Spinner.foreground", controlForeground, "Spinner.borderPainted", Boolean.TRUE, "SplitPane.background", controlBackground, "SplitPane.foreground", controlForeground, "SplitPaneDivider.draggingColor", new AlphaColorUIResource(-1603901850), "TabbedPane.background", controlBackground, "TabbedPane.disabledForeground", disabledForeground, "TabbedPane.foreground", controlForeground, "TabbedPane.wrap.background", controlBackground, "TabbedPane.wrap.disabledForeground", disabledForeground, "TabbedPane.wrap.foreground", controlForeground, "TabbedPane.scroll.background", controlBackground, "TabbedPane.scroll.disabledForeground", disabledForeground, "TabbedPane.scroll.foreground", controlForeground, "Table.alternateBackground.0", listAlternateBackground, "Table.alternateBackground.1", listBackground, "Table.focusCellBackground", listBackground, "Table.focusCellForeground", listForeground, "Table.background", listBackground, "Table.foreground", listForeground, "Table.selectionBackground", listSelectionBackground, "Table.selectionForeground", listSelectionForeground, "Table.gridColor", listBackground, "Table.focusCellForeground", listSelectionForeground, "Table.focusCellBackground", listSelectionBackground, "TableHeader.background", controlBackground, "TableHeader.foreground", controlForeground, "TextArea.background", textBackground, "TextArea.foreground", textForeground, "TextArea.inactiveForeground", disabledForeground, "TextArea.selectionBackground", textSelectionBackground, "TextArea.selectionForeground", textForeground, "TextField.background", textBackground, "TextField.foreground", textForeground, "TextField.inactiveBackground", textBackground, "TextField.inactiveForeground", disabledForeground, "TextField.inactiveSelectionBackground", inactiveSelectionBackground, "TextField.selectionBackground", textSelectionBackground, "TextField.selectionForeground", textForeground, "TextPane.background", textBackground, "TextPane.foreground", textForeground, "TextPane.inactiveForeground", disabledForeground, "TextPane.selectionBackground", textSelectionBackground, "TextPane.selectionForeground", textForeground, "ToggleButton.background", controlBackground, "ToggleButton.disabledForeground", disabledForeground, "ToggleButton.foreground", controlForeground, "ToolBar.dockingForeground", listSelectionBackground, "ToolBar.floatingForeground", new AlphaColorUIResource(0), "ToolTip.foreground", table.get("infoText"), "ToolTip.background", table.get("info"), "Tree.alternateBackground.0", listAlternateBackground, "Tree.alternateBackground.1", listBackground, "Tree.selectionBackground", listSelectionBackground, "Tree.selectionBorderColor", listSelectionBorderColor, "Tree.selectionForeground", listSelectionForeground, "Tree.controlForeground", listForeground, "Tree.textBackground", translucentColor, "Tree.textForeground", listForeground, "Viewport.background", listBackground, "Viewport.foreground", listForeground};
        table.putDefaults(objects);
    }

    protected void initInputMapDefaults(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap passwordFieldInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "beep", "meta C", "beep", "meta V", "paste-from-clipboard", "CUT", "beep", "COPY", "beep", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap spinnerInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new String[]{"shift ENTER", "insert-break", "alt ENTER", "insert-break", "ENTER", "insert-break", "TAB", "insert-tab", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word"});
        UIDefaults.LazyInputMap comboEditorInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "ctrl LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap tabbedPaneFocusInputMap = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"});
        UIDefaults.LazyInputMap tabbedPaneAncestorInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"});
        Object[] objects = new Object[]{"ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.editorInputMap", comboEditorInputMap, "FormattedTextField.focusInputMap", fieldInputMap, "FormattedTextField.keyBindings", null, "PasswordField.focusInputMap", passwordFieldInputMap, "PasswordField.keyBindings", null, "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.focusInputMap", spinnerInputMap, "TabbedPane.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.actionMap", table.get("TabbedPane.actionMap"), "TabbedPane.wrap.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.wrap.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.wrap.actionMap", table.get("TabbedPane.actionMap"), "TabbedPane.scroll.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.scroll.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.scroll.actionMap", table.get("TabbedPane.actionMap"), "TextArea.focusInputMap", multilineInputMap, "TextArea.keyBindings", null, "TextField.focusInputMap", fieldInputMap, "TextField.keyBindings", null, "TextPane.focusInputMap", multilineInputMap, "TextPane.keyBindings", null, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "alt UP", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "alt DOWN", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "meta A", "selectAll", "meta shift A", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"})};
        table.putDefaults(objects);
    }

    protected String getSystemFontName() {
        return "Lucida Grande";
    }

    protected void initFontDefaults(UIDefaults table) {
        String systemFontName = this.getSystemFontName();
        Integer fourteen = new Integer(14);
        Integer thirteen = new Integer(13);
        Integer twelve = new Integer(12);
        Integer eleven = new Integer(11);
        Integer ten = new Integer(11);
        Integer nine = new Integer(9);
        Integer fontPlain = new Integer(0);
        Integer fontBold = new Integer(1);
        UIDefaults.ProxyLazyValue systemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, thirteen});
        UIDefaults.ProxyLazyValue emphasizedSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontBold, thirteen});
        UIDefaults.ProxyLazyValue smallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, eleven});
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontBold, eleven});
        UIDefaults.ProxyLazyValue miniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, nine});
        UIDefaults.ProxyLazyValue emphasizedMiniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontBold, nine});
        UIDefaults.ProxyLazyValue applicationFont = systemFont;
        UIDefaults.ProxyLazyValue labelFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, ten});
        UIDefaults.ProxyLazyValue viewFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, twelve});
        UIDefaults.ProxyLazyValue menuFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{systemFontName, fontPlain, fourteen});
        if (QuaquaManager.getProperty("Quaqua.sizeStyle", "regular").equals("small")) {
            viewFont = smallSystemFont;
            systemFont = smallSystemFont;
            emphasizedSystemFont = emphasizedSmallSystemFont;
            menuFont = smallSystemFont;
            applicationFont = smallSystemFont;
        }
        Object[] objects = new Object[]{"SystemFont", systemFont, "EmphasizedSystemFont", emphasizedSystemFont, "SmallSystemFont", smallSystemFont, "EmphasizedSmallSystemFont", emphasizedSmallSystemFont, "MiniSystemFont", miniSystemFont, "EmphasizedMiniSystemFont", miniSystemFont, "ApplicationFont", applicationFont, "LabelFont", labelFont, "ViewFont", viewFont, "MenuFont", menuFont, "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Browser.font", viewFont, "Button.font", systemFont, "Button.smallFont", smallSystemFont, "CheckBox.font", systemFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "CheckBoxMenuItem.font", menuFont, "ColorChooser.font", smallSystemFont, "ColorChooser.crayonsFont", systemFont, "ComboBox.font", systemFont, "EditorPane.font", applicationFont, "FormattedTextField.font", applicationFont, "FileChooser.previewLabelFont", smallSystemFont, "FileChooser.previewValueFont", smallSystemFont, "IconButton.font", smallSystemFont, "InternalFrame.optionDialogTitleFont", menuFont, "InternalFrame.titleFont", menuFont, "Label.font", systemFont, "List.font", viewFont, "List.focusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{table.get("listHighlightBorder")}), "Menu.acceleratorFont", menuFont, "Menu.font", menuFont, "MenuBar.font", menuFont, "MenuItem.acceleratorFont", menuFont, "MenuItem.font", menuFont, "OptionPane.buttonFont", systemFont, "OptionPane.font", systemFont, "OptionPane.messageFont", emphasizedSystemFont, "OptionPane.htmlMessageFont", systemFont, "Panel.font", systemFont, "PasswordField.font", applicationFont, "PopupMenu.font", menuFont, "ProgressBar.font", systemFont, "RadioButton.font", systemFont, "RadioButtonMenuItem.acceleratorFont", menuFont, "RadioButtonMenuItem.font", menuFont, "RootPane.font", systemFont, "ScrollBar.font", systemFont, "ScrollPane.font", systemFont, "Slider.labelFont", labelFont, "Spinner.font", systemFont, "TabbedPane.font", systemFont, "TabbedPane.smallFont", smallSystemFont, "TabbedPane.wrap.font", systemFont, "TabbedPane.wrap.smallFont", smallSystemFont, "TabbedPane.scroll.font", systemFont, "TabbedPane.scroll.smallFont", smallSystemFont, "Table.font", viewFont, "TableHeader.font", smallSystemFont, "TextArea.font", applicationFont, "TextField.font", applicationFont, "TextPane.font", applicationFont, "TitledBorder.font", smallSystemFont, "ToggleButton.font", systemFont, "ToolBar.font", miniSystemFont, "ToolBar.titleFont", miniSystemFont, "ToolTip.font", smallSystemFont, "Tree.font", viewFont, "Viewport.font", systemFont};
        table.putDefaults(objects);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        String systemFontName = this.getSystemFontName();
        Boolean isRequestFocusEnabled = new Boolean(QuaquaManager.getProperty("Quaqua.requestFocusEnabled", "false").equals("true"));
        UIDefaults.ProxyLazyValue dialogBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$DialogBorder");
        UIDefaults.ProxyLazyValue questionDialogBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$QuestionDialogBorder");
        ColorUIResource listSelectionBorderColor = (ColorUIResource)table.get("listHighlightBorder");
        Color menuBackground = (Color)table.get("menu");
        Integer zero = new Integer(0);
        Integer one = new Integer(1);
        Integer two = new Integer(2);
        Integer three = new Integer(3);
        Integer four = new Integer(4);
        Integer ten = new Integer(10);
        int[] values = QuaquaManager.getProperty("Quaqua.visualMargin", new int[]{3, 3, 3, 3});
        InsetsUIResource visualMargin = new InsetsUIResource(values[0], values[1], values[2], values[3]);
        Boolean opaque = new Boolean(QuaquaManager.getProperty("Quaqua.opaque", "false").equals("true"));
        Boolean autovalidate = new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.autovalidate", "true").equals("true"));
        UIDefaults.ProxyLazyValue textComponentPopupHandler = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTextComponentPopupHandler");
        Boolean autoselect = new Boolean(QuaquaManager.getProperty("Quaqua.TextComponent.autoSelect", "true").equals("true"));
        UIDefaults.ProxyLazyValue scrollPaneBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaScrollPaneBorder$UIResource", new Object[]{"/ch/randelshofer/quaqua/images/ScrollPane.borders.png", "/ch/randelshofer/quaqua/images/TextField.borders.png"});
        UIDefaults.ProxyLazyValue textFieldBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTextFieldBorder$UIResource", new Object[]{"/ch/randelshofer/quaqua/images/TextField.borders.png", "/ch/randelshofer/quaqua/images/TextField.searchBorders.png", "/ch/randelshofer/quaqua/images/TextField.small.searchBorders.png"});
        Boolean enforceVisualMargin = new Boolean(QuaquaManager.getProperty("Quaqua.enforceVisualMargin", "false").equals("true"));
        Object[] objects = new Object[]{"Browser.expandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", four, Boolean.TRUE, zero}), "Browser.expandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", four, Boolean.TRUE, one}), "Browser.selectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", four, Boolean.TRUE, two}), "Browser.selectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", four, Boolean.TRUE, three}), "Button.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createButtonBorder", new Object[]{"push"}), "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "Button.opaque", opaque, "Button.textIconGap", four, "Button.textShiftOffset", zero, "Button.helpIcon", this.makeOverlaidButtonStateIcon("/ch/randelshofer/quaqua/images/Button.helpIcons.png", 10, "/ch/randelshofer/quaqua/images/Button.helpFocusRings.png", 2, new Rectangle(0, 0, 25, 25)), "Button.requestFocusEnabled", isRequestFocusEnabled, "CheckBox.border", new VisualMargin(0, 0, 0, 0), "CheckBox.icon", this.makeOverlaidButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBox.icons.png", 10, "/ch/randelshofer/quaqua/images/CheckBox.focusRings.png", 2, new Rectangle(2, 2, 14, 14)), "CheckBox.margin", new InsetsUIResource(0, 0, 0, 0), "CheckBox.opaque", opaque, "CheckBox.smallIcon", this.makeOverlaidButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBox.small.icons.png", 10, "/ch/randelshofer/quaqua/images/CheckBox.small.focusRings.png", 2, new Rectangle(2, 2, 12, 12)), "CheckBox.textIconGap", four, "CheckBox.textShiftOffset", zero, "CheckBox.requestFocusEnabled", isRequestFocusEnabled, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "ColorChooser.defaultChoosers", new String[]{"ch.randelshofer.quaqua.colorchooser.ColorWheelChooser", "ch.randelshofer.quaqua.colorchooser.ColorSlidersChooser", "ch.randelshofer.quaqua.colorchooser.ColorPalettesChooser", "ch.randelshofer.quaqua.colorchooser.SwatchesChooser", "ch.randelshofer.quaqua.colorchooser.CrayonsChooser", "ch.randelshofer.quaqua.colorchooser.Quaqua15ColorPicker"}, "ColorChooser.swatchesSwatchSize", new DimensionUIResource(5, 5), "ColorChooser.resetMnemonic", new Integer(-1), "ColorChooser.crayonsImage", this.makeImage("/ch/randelshofer/quaqua/images/ColorChooser.crayons.png"), "ColorChooser.textSliderGap", zero, "ColorChooser.colorPalettesIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorPalettesIcons.png", 3), "ColorChooser.colorSlidersIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorSlidersIcons.png", 3), "ColorChooser.colorSwatchesIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorSwatchesIcons.png", 3), "ColorChooser.colorWheelIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorWheelIcons.png", 3), "ColorChooser.crayonsIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.crayonsIcons.png", 3), "ColorChooser.imagePalettesIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.imagePalettesIcons.png", 3), "ColorChooser.colorPickerIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/ColorChooser.colorPickerIcon.png"), "ColorChooser.colorPickerMagnifier", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ColorChooser.colorPickerMagnifier.png"), "ColorChooser.colorPickerHotSpot", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(29), new Integer(29)}), "ColorChooser.colorPickerPickOffset", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(-13), new Integer(-13)}), "ColorChooser.colorPickerGlassRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(2), new Integer(2), new Integer(29), new Integer(29)}), "ColorChooser.colorPickerCaptureRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(-15), new Integer(-15), new Integer(5), new Integer(5)}), "ColorChooser.colorPickerZoomRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(4), new Integer(4), new Integer(25), new Integer(25)}), "ComboBox.border", new QuaquaComboBoxVisualMargin(2, 2, 2, 2), "ComboBox.dropDownIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ComboBox.dropDownIcons.png", 6), "ComboBox.opaque", opaque, "ComboBox.popupIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ComboBox.popupIcons.png", 6), "ComboBox.smallPopupIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ComboBox.small.popupIcons.png", 6), "ComboBox.smallDropDownIcon", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ComboBox.small.dropDownIcons.png", 6), "ComboBox.maximumRowCount", new Integer(8), "ComboBox.requestFocusEnabled", isRequestFocusEnabled, "ComboBox.harmonizePreferredHeight", Boolean.FALSE, "ComboBoxButton.margin", new InsetsUIResource(0, 0, 0, 0), "ComboBox.changeEditorForeground", Boolean.TRUE, "Component.visualMargin", visualMargin, "CheckBox.enforceVisualMargin", enforceVisualMargin, "RadioButton.enforceVisualMargin", enforceVisualMargin, "EditorPane.margin", new InsetsUIResource(1, 3, 1, 3), "EditorPane.popupHandler", textComponentPopupHandler, "FileChooser.homeFolderIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileChooser.homeFolderIcon.png"), "FileChooser.autovalidate", autovalidate, "FileChooser.previewLabelForeground", new ColorUIResource(0), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.splitPaneDividerSize", four, "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 1), "FileChooser.previewLabelDelimiter", ":", "FileChooser.speed", new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.speed") != null && QuaquaManager.getProperty("Quaqua.FileChooser.speed").equals("true")), "FileView.computerIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.computerIcon.png"), "FileView.fileIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.fileIcon.png"), "FileView.directoryIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.directoryIcon.png"), "FileChooser.orderByType", new Boolean(QuaquaManager.getProperty("Quaqua.FileChooser.speed") != null && QuaquaManager.getProperty("Quaqua.FileChooser.orderByType").equals("true")), "FormattedTextField.border", textFieldBorder, "FormattedTextField.opaque", opaque, "FormattedTextField.popupHandler", textComponentPopupHandler, "FormattedTextField.autoSelect", autoselect, "Label.border", new VisualMargin(0, 0, 0, 0), "Label.opaque", opaque, "List.cellRenderer", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaDefaultListCellRenderer"), "Menu.borderPainted", Boolean.TRUE, "MenuItem.borderPainted", Boolean.TRUE, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0), "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.errorIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{new Integer(0)}), "OptionPane.informationIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{new Integer(1)}), "OptionPane.questionIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{new Integer(3)}), "OptionPane.warningIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{new Integer(2)}), "OptionPane.css", "<head><style type=\"text/css\">b { font: 13pt \"" + systemFontName + "\" }" + "p { font: 11pt \"" + systemFontName + "\"; margin-top: 8px }" + "</style>" + "</head>", "OptionPane.messageLabelWidth", new Integer(360), "OptionPane.maxCharactersPerLineCount", new Integer(60), "Panel.opaque", opaque, "PasswordField.border", textFieldBorder, "PasswordField.opaque", opaque, "PasswordField.popupHandler", textComponentPopupHandler, "PasswordField.autoSelect", autoselect, "RadioButton.border", new VisualMargin(0, 0, 0, 0), "RadioButton.margin", new InsetsUIResource(0, 0, 0, 0), "RadioButton.icon", this.makeOverlaidButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButton.icons.png", 10, "/ch/randelshofer/quaqua/images/RadioButton.focusRing.png", 1, new Rectangle(2, 2, 14, 15)), "RadioButton.smallIcon", this.makeOverlaidButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButton.small.icons.png", 10, "/ch/randelshofer/quaqua/images/RadioButton.small.focusRing.png", 1, new Rectangle(2, 1, 12, 13)), "RadioButton.opaque", opaque, "RadioButton.textIconGap", four, "RadioButton.textShiftOffset", zero, "RadioButton.requestFocusEnabled", isRequestFocusEnabled, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RootPane.opaque", Boolean.TRUE, "RootPane.frameBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$FrameBorder"), "RootPane.plainDialogBorder", dialogBorder, "RootPane.informationDialogBorder", dialogBorder, "RootPane.errorDialogBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$ErrorDialogBorder"), "RootPane.colorChooserDialogBorder", questionDialogBorder, "RootPane.fileChooserDialogBorder", questionDialogBorder, "RootPane.questionDialogBorder", questionDialogBorder, "RootPane.warningDialogBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$WarningDialogBorder"), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "RootPane.windowSnapDistance", new Integer(10), "RootPane.draggableWindowBackground", Boolean.FALSE, "RootPane.windowShadow", Boolean.TRUE, "ScrollBar.placeButtonsTogether", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new Boolean(Preferences.getString("AppleScrollBarVariant").equals("DoubleMax"));
            }
        }, "ScrollBar.supportsAbsolutePositioning", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new Boolean(Preferences.getString("AppleScrollerPagingBehavior").equals("true"));
            }
        }, "ScrollBar.minimumThumbSize", new DimensionUIResource(24, 24), "ScrollBar.smallMinimumThumbSize", new DimensionUIResource(18, 18), "ScrollBar.maximumThumbSize", new DimensionUIResource(Integer.MAX_VALUE, Integer.MAX_VALUE), "ScrollBar.hThumbBody", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ScrollBar.hThumbBody.png"), "ScrollBar.hThumbLeft", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.hThumbLeft.png", 5, false), "ScrollBar.hThumbRight", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.hThumbRight.png", 5, false), "ScrollBar.hTrack", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.hTrack.png", new Insets(15, 0, 0, 0)), "ScrollBar.ihThumb", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.ihThumb.png", new Insets(15, 11, 0, 11)), "ScrollBar.sep.hButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.sep.hButtons.png", new Insets(15, 28, 0, 28), 4, false), "ScrollBar.tog.hButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.tog.hButtons.png", new Insets(15, 18, 0, 44), 4, false), "ScrollBar.vThumbBody", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ScrollBar.vThumbBody.png"), "ScrollBar.vThumbTop", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.vThumbTop.png", 5, true), "ScrollBar.vThumbBottom", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.vThumbBottom.png", 5, true), "ScrollBar.vTrack", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.vTrack.png", new Insets(0, 15, 0, 0)), "ScrollBar.ivThumb", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.ivThumb.png", new Insets(11, 15, 11, 0)), "ScrollBar.sep.vButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.sep.vButtons.png", new Insets(28, 15, 28, 0), 4, true), "ScrollBar.tog.vButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.tog.vButtons.png", new Insets(18, 15, 44, 0), 4, true), "ScrollBar.small.hThumbBody", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ScrollBar.small.hThumbBody.png"), "ScrollBar.small.hThumbLeft", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.small.hThumbLeft.png", 5, false), "ScrollBar.small.hThumbRight", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.small.hThumbRight.png", 5, false), "ScrollBar.small.hTrack", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.small.hTrack.png", new Insets(11, 0, 0, 0)), "ScrollBar.small.ihThumb", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.small.ihThumb.png", new Insets(11, 8, 0, 8)), "ScrollBar.smallSep.hButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.smallSep.hButtons.png", new Insets(11, 21, 0, 21), 4, false), "ScrollBar.smallTog.hButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.smallTog.hButtons.png", new Insets(11, 14, 0, 34), 4, false), "ScrollBar.small.vThumbBody", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ScrollBar.small.vThumbBody.png"), "ScrollBar.small.vThumbTop", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.small.vThumbTop.png", 5, true), "ScrollBar.small.vThumbBottom", BasicQuaquaLookAndFeel.makeIcons("/ch/randelshofer/quaqua/images/ScrollBar.small.vThumbBottom.png", 5, true), "ScrollBar.small.vTrack", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.small.vTrack.png", new Insets(0, 11, 0, 0)), "ScrollBar.small.ivThumb", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/ScrollBar.small.ivThumb.png", new Insets(8, 11, 8, 0)), "ScrollBar.smallSep.vButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.smallSep.vButtons.png", new Insets(21, 11, 21, 0), 4, true), "ScrollBar.smallTog.vButtons", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/ScrollBar.smallTog.vButtons.png", new Insets(14, 11, 34, 0), 4, true), "ScrollBar.focusable", Boolean.FALSE, "ScrollPane.border", scrollPaneBorder, "ScrollPane.requesFocusEnabled", Boolean.FALSE, "ScrollPane.focusable", Boolean.FALSE, "ScrollPane.opaque", opaque, "Separator.border", new VisualMargin(), "Sheet.showAsSheet", Boolean.TRUE, "Slider.upThumbSmall", BasicQuaquaLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.up.thumbs.png"), "Slider.leftThumbSmall", BasicQuaquaLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.left.thumbs.png"), "Slider.opaque", opaque, "Slicer.requestFocusEnabled", isRequestFocusEnabled, "Spinner.arrowButtonBorder", null, "Spinner.arrowButtonInsets", null, "Spinner.border", null, "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.opaque", opaque, "Spinner.north", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.north.png", 10), "Spinner.south", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.south.png", 10), "Spinner.smallNorth", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.small.north.png", 10), "Spinner.smallSouth", BasicQuaquaLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.small.south.png", 10), "SplitPane.opaque", opaque, "SplitPane.border", null, "SplitPane.dividerSize", ten, "SplitPane.thumbDimple", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.thumbDimple.png"), "SplitPane.barDimple", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.barDimple.png"), "SplitPane.hBar", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/SplitPane.hBar.png", new Insets(4, 0, 5, 0), true), "SplitPane.vBar", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/SplitPane.vBar.png", new Insets(0, 4, 0, 5), true), "SplitPane.upArrow", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.upArrow.png"), "SplitPane.downArrow", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.downArrow.png"), "SplitPane.rightArrow", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.rightArrow.png"), "SplitPane.leftArrow", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.leftArrow.png"), "SplitPane.focusable", Boolean.FALSE, "SplitPane.requestFocusEnabled", Boolean.FALSE, "SplitPaneDivider.border", null, "SplitPaneDivider.focusable", Boolean.FALSE, "SplitPaneDivider.requestFocusEnabled", Boolean.FALSE, "TabbedPane.opaque", opaque, "TabbedPane.wrap.opaque", opaque, "TabbedPane.scroll.opaque", opaque, "TabbedPane.requestFocusEnabled", isRequestFocusEnabled, "Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(listSelectionBorderColor), "Table.scrollPaneBorder", scrollPaneBorder, "TableHeader.cellBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTableHeaderBorder$UIResource", new Object[]{"/ch/randelshofer/quaqua/images/TableHeader.borders.png", new Insets(6, 1, 9, 1)}), "TextArea.margin", new InsetsUIResource(1, 3, 1, 3), "TextArea.opaque", Boolean.TRUE, "TextArea.popupHandler", textComponentPopupHandler, "TextField.border", textFieldBorder, "TextField.opaque", Boolean.FALSE, "TextField.popupHandler", textComponentPopupHandler, "TextField.autoSelect", autoselect, "TextPane.margin", new InsetsUIResource(1, 3, 1, 3), "TextPane.opaque", Boolean.TRUE, "TextPane.popupHandler", textComponentPopupHandler, "ToggleButton.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createButtonBorder", new Object[]{"toggle"}), "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToggleButton.opaque", opaque, "ToggleButton.textIconGap", four, "ToggleButton.textShiftOffset", zero, "ToggleButton.requestFocusEnabled", isRequestFocusEnabled, "ToolBar.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaToolBarBorder$UIResource"), "ToolBar.separatorSize", null, "ToolBar.margin", new InsetsUIResource(0, 0, 0, 0), "ToolTip.border", new BorderUIResource.LineBorderUIResource(new ColorUIResource(0x303030)), "Tree.collapsedIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.collapsedIcon.png"), "Tree.expandedIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.expandedIcon.png"), "Tree.leftChildIndent", new Integer(7), "Tree.line", new AlphaColorUIResource(0), "Tree.paintLines", Boolean.FALSE, "Tree.rightChildIndent", new Integer(13), "Tree.rowHeight", new Integer(19), "Tree.leafIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.leafIcon.png"), "Tree.openIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.openIcon.png"), "Tree.closedIcon", BasicQuaquaLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.closedIcon.png"), "Viewport.opaque", Boolean.TRUE, "Quaqua.Debug.colorizePaintEvents", new Boolean(QuaquaManager.getProperty("Quaqua.Debug.colorizePaintEvents", "false").equals("true")), "Quaqua.Debug.showClipBounds", new Boolean(QuaquaManager.getProperty("Quaqua.Debug.showClipBounds", "false").equals("true")), "Quaqua.Debug.showVisualBounds", new Boolean(QuaquaManager.getProperty("Quaqua.Debug.showVisualBounds", "false").equals("true")), "Quaqua.Debug.clipBoundsForeground", new AlphaColorUIResource(0, 0, 255, 128), "Quaqua.Debug.componentBoundsForeground", new AlphaColorUIResource(255, 0, 0, 128), "Quaqua.Debug.textBoundsForeground", new AlphaColorUIResource(255, 0, 0, 128)};
        table.putDefaults(objects);
        String javaVersion = QuaquaManager.getProperty("java.version", "");
        objects = javaVersion.startsWith("1.3") || javaVersion.startsWith("1.4") || javaVersion.startsWith("1.5") ? new Object[]{"LayoutStyle.instance", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaLayoutStyle"), "Baseline.instance", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBaseline")} : new Object[]{"LayoutStyle.instance", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.Quaqua16LayoutStyle")};
        table.putDefaults(objects);
    }

    protected Object makeImage(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createImage", new Object[]{location});
    }

    protected Object makeBufferedImage(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createBufferedImage", new Object[]{location});
    }

    public static Object makeIcon(Class baseClass, String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location});
    }

    public static Object makeIcon(Class baseClass, String location, Point shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location, shift});
    }

    public static Object makeIcon(Class baseClass, String location, Rectangle shiftAndSize) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location, shiftAndSize});
    }

    protected static Object makeIcons(String location, int states, boolean horizontal) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcons", new Object[]{location, new Integer(states), new Boolean(horizontal)});
    }

    protected static Object makeButtonStateIcon(String location, int states) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, new Integer(states)});
    }

    protected static Object makeButtonStateIcon(String location, int states, Point shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, new Integer(states), shift});
    }

    protected static Object makeButtonStateIcon(String location, int states, Rectangle shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, new Integer(states), shift});
    }

    protected static Object makeFrameButtonStateIcon(String location, int states) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createFrameButtonStateIcon", new Object[]{location, new Integer(states)});
    }

    protected static Object makeSliderThumbIcon(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createSliderThumbIcon", new Object[]{location});
    }

    protected Object makeOverlaidButtonStateIcon(String location1, int states1, String location2, int states2, Rectangle layoutRect) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOverlaidButtonStateIcon", new Object[]{location1, new Integer(states1), location2, new Integer(states2), layoutRect});
    }

    protected Object makeImageBevelBorder(String location, Insets insets) {
        return this.makeImageBevelBorder(location, insets, false);
    }

    protected Object makeImageBevelBorder(String location, Insets insets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, insets, new Boolean(fill)});
    }

    protected Object makeImageBevelBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, imageInsets, borderInsets, new Boolean(fill)});
    }

    protected Object makeImageBevelBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createBackgroundBorder", new Object[]{location, imageInsets, borderInsets, new Boolean(fill)});
    }

    protected Object makeImageBevelBorders(String location, Insets insets, int states, boolean horizontal) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, insets, new Integer(states), new Boolean(horizontal)});
    }

    protected Object makeTextureColor(int rgb, String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.util.TextureColor$UIResource", new Object[]{new Integer(rgb), location});
    }

    protected void initDesignDefaults(UIDefaults table) {
    }

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    protected boolean isJaguarTabbedPane() {
        String property;
        try {
            property = QuaquaManager.getProperty("Quaqua.tabLayoutPolicy");
            if (property == null) {
                property = QuaquaManager.getProperty("Quaqua.TabbedPane.design", "auto");
            }
        }
        catch (AccessControlException e) {
            property = "auto";
        }
        return property.equals("jaguar") || property.equals("wrap");
    }

    protected void installKeyboardFocusManager() {
    }
}

