/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.VisuallyLayoutable;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import org.jdesktop.layout.LayoutStyle;

public class Quaqua14LayoutStyle
extends LayoutStyle {
    private static final boolean DEBUG = false;
    private static final int MINI = 0;
    private static final int SMALL = 1;
    private static final int REGULAR = 2;
    private static final Object[][] containerGapDefinitions = new Object[][]{{"TabbedPaneUI", new Insets(6, 10, 10, 10), new Insets(6, 10, 10, 12), new Insets(12, 20, 20, 20)}, {"RootPaneUI", new Insets(8, 10, 10, 10), new Insets(8, 10, 10, 12), new Insets(14, 20, 20, 20)}, {"default", new Insets(8, 10, 10, 10), new Insets(8, 10, 10, 12), new Insets(14, 20, 20, 20)}};
    private static final Object[][] relatedGapDefinitions = new Object[][]{{"ButtonUI", "ButtonUI.push", "ButtonUI.text", "ToggleButtonUI.push", "ToggleButtonUI.text", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"ButtonUI.metal", "ToggleButtonUI.metal", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(12, 12, 12, 12)}, {"ButtonUI.bevel", "ButtonUI.toggle", "ButtonUI.square", "ToggleButtonUI", "ToggleButtonUI.bevel", "ToggleButtonUI.square", "ToggleButtonUI.toggle", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.bevel.largeIcon", "ToggleButtonUI.bevel.largeIcon", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8)}, {"ButtonUI.icon", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.icon.largeIcon", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8)}, {"ButtonUI.round", "ToggleButtonUI.round", new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12)}, {"ButtonUI.help", new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12)}, {"ButtonUI.toggleCenter", "ToggleButtonUI.toggleCenter", new Insets(8, 0, 8, 0), new Insets(10, 0, 10, 0), new Insets(12, 0, 12, 0)}, {"ButtonUI.toggleEast", "ToggleButtonUI.toggleEast", new Insets(8, 0, 8, 8), new Insets(10, 0, 10, 10), new Insets(12, 0, 12, 12)}, {"ButtonUI.toggleWest", "ToggleButtonUI.toggleWest", new Insets(8, 8, 8, 0), new Insets(10, 10, 10, 0), new Insets(12, 12, 12, 0)}, {"ButtonUI.toolBarTab", "ToggleButtonUI.toolBarTab", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.colorWell", "ToggleButtonUI.colorWell", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"CheckBoxUI", new Insets(6, 5, 6, 5), new Insets(7, 6, 7, 6), new Insets(7, 6, 7, 6)}, {"ComboBoxUI", new Insets(8, 5, 8, 5), new Insets(10, 6, 10, 6), new Insets(12, 8, 12, 8)}, {"LabelUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8)}, {"ListUI", new Insets(5, 5, 5, 5), new Insets(6, 6, 6, 6), new Insets(6, 6, 6, 6)}, {"PanelUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ProgressBarUI", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"RadioButtonUI", new Insets(5, 5, 5, 5), new Insets(6, 6, 6, 6), new Insets(6, 6, 6, 6)}, {"ScrollPaneUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"SeparatorUI", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"SliderUI.horizontal", new Insets(6, 8, 6, 8), new Insets(6, 10, 6, 10), new Insets(6, 12, 6, 12)}, {"SliderUI.vertical", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"SpinnerUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"SplitPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TabbedPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TableUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TextAreaUI", "EditorPaneUI", "TextPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TextFieldUI", "FormattedTextFieldUI", "PasswordFieldUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"TreeUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}};
    private static final Object[][] unrelatedGapDefinitions = new Object[][]{{"ButtonUI.help", new Insets(24, 24, 24, 24), new Insets(24, 24, 24, 24), new Insets(24, 24, 24, 24)}, {"default", new Insets(12, 12, 12, 12), new Insets(14, 14, 14, 14), new Insets(16, 16, 16, 16)}};
    private static final Object[][] indentGapDefinitions = new Object[][]{{"default", new Insets(16, 16, 16, 16), new Insets(20, 20, 20, 20), new Insets(25, 25, 25, 25)}};
    private static final HashMap relatedGaps = Quaqua14LayoutStyle.createMap(relatedGapDefinitions);
    private static final HashMap unrelatedGaps = Quaqua14LayoutStyle.createMap(unrelatedGapDefinitions);
    private static final HashMap containerGaps = Quaqua14LayoutStyle.createMap(containerGapDefinitions);
    private static final HashMap indentGaps = Quaqua14LayoutStyle.createMap(indentGapDefinitions);

    private static HashMap createMap(Object[][] definitions) {
        HashMap<Object, Insets[]> map = new HashMap<Object, Insets[]>();
        for (int i = 0; i < definitions.length; ++i) {
            int j;
            int keys;
            for (keys = 0; keys < definitions[i].length && definitions[i][keys] instanceof String; ++keys) {
            }
            Insets[] values = new Insets[definitions[i].length - keys];
            for (j = keys; j < definitions[i].length; ++j) {
                values[j - keys] = (Insets)definitions[i][j];
            }
            for (j = 0; j < keys; ++j) {
                map.put(definitions[i][j], values);
            }
        }
        return map;
    }

    public int getPreferredGap(JComponent component1, JComponent component2, int type, int position, Container parent) {
        int result;
        if (type == 3) {
            int sizeStyle = this.getSizeStyle(component1);
            Insets vgap = this.getVisualIndent(component1);
            Insets pgap = this.getPreferredGap(component1, 3, sizeStyle);
            switch (position) {
                case 1: {
                    result = vgap.bottom > 3 ? vgap.bottom : pgap.bottom;
                    break;
                }
                case 5: {
                    result = vgap.top > 3 ? vgap.top : pgap.top;
                    break;
                }
                case 3: {
                    result = vgap.left > 3 ? vgap.left : pgap.left;
                    break;
                }
                default: {
                    result = vgap.right > 3 ? vgap.right : pgap.right;
                }
            }
            Insets visualMargin2 = this.getVisualMargin(component2);
            switch (position) {
                case 1: {
                    result -= visualMargin2.bottom;
                    break;
                }
                case 5: {
                    result -= visualMargin2.top;
                    break;
                }
                case 3: {
                    result -= visualMargin2.left;
                    break;
                }
                case 7: {
                    result -= visualMargin2.right;
                }
            }
        } else {
            int sizeStyle = Math.min(this.getSizeStyle(component1), this.getSizeStyle(component2));
            Insets gap1 = this.getPreferredGap(component1, type, sizeStyle);
            Insets gap2 = this.getPreferredGap(component2, type, sizeStyle);
            switch (position) {
                case 1: {
                    result = Math.max(gap1.top, gap2.bottom);
                    break;
                }
                case 5: {
                    result = Math.max(gap1.bottom, gap2.top);
                    break;
                }
                case 3: {
                    result = Math.max(gap1.right, gap2.left);
                    break;
                }
                default: {
                    result = Math.max(gap1.left, gap2.right);
                }
            }
            Insets visualMargin1 = this.getVisualMargin(component1);
            Insets visualMargin2 = this.getVisualMargin(component2);
            switch (position) {
                case 1: {
                    result -= visualMargin1.top + visualMargin2.bottom;
                    break;
                }
                case 5: {
                    result -= visualMargin1.bottom + visualMargin2.top;
                    break;
                }
                case 3: {
                    result -= visualMargin1.right + visualMargin2.left;
                    break;
                }
                case 7: {
                    result -= visualMargin1.left + visualMargin2.right;
                }
            }
        }
        return result;
    }

    private Insets getPreferredGap(JComponent component, int type, int sizeStyle) {
        String key;
        Insets[] gaps;
        HashMap gapMap;
        Object gap = null;
        switch (type) {
            case 3: {
                gapMap = indentGaps;
                break;
            }
            case 0: {
                gapMap = relatedGaps;
                break;
            }
            default: {
                gapMap = unrelatedGaps;
            }
        }
        String uid = component.getUIClassID();
        String style = null;
        if (uid.equals("ButtonUI") || uid.equals("ToggleButtonUI")) {
            style = (String)component.getClientProperty("Quaqua.Button.style");
            if (style == null) {
                style = (String)component.getClientProperty("JButton.buttonType");
            }
        } else if (uid.equals("ProgressBarUI")) {
            style = ((JProgressBar)component).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (uid.equals("SliderUI")) {
            style = ((JSlider)component).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (uid.equals("TabbedPaneUI")) {
            switch (((JTabbedPane)component).getTabPlacement()) {
                case 1: {
                    style = "top";
                    break;
                }
                case 2: {
                    style = "left";
                    break;
                }
                case 3: {
                    style = "bottom";
                    break;
                }
                case 4: {
                    style = "right";
                }
            }
        }
        if ((gaps = (Insets[])gapMap.get(key = style == null ? uid : uid + "." + style)) == null) {
            gaps = (Insets[])gapMap.get(uid);
        }
        if (gaps == null) {
            gaps = (Insets[])gapMap.get("default");
        }
        return gaps == null ? new Insets(0, 0, 0, 0) : (Insets)gaps[sizeStyle].clone();
    }

    public int getContainerGap(JComponent component, int position, Container parent) {
        int result;
        int sizeStyle = Math.min(this.getSizeStyle(component), this.getSizeStyle(parent));
        Insets gap = this.getContainerGap(parent, sizeStyle);
        switch (position) {
            case 1: {
                result = gap.top;
                break;
            }
            case 5: {
                result = gap.bottom;
                break;
            }
            case 3: {
                result = gap.right;
                break;
            }
            default: {
                result = gap.left;
            }
        }
        Insets visualMargin = this.getVisualMargin(component);
        switch (position) {
            case 1: {
                result -= visualMargin.top;
                break;
            }
            case 5: {
                result -= visualMargin.bottom;
                if (!(component instanceof JRadioButton)) break;
                --result;
                break;
            }
            case 3: {
                result -= visualMargin.left;
                break;
            }
            case 7: {
                result -= visualMargin.right;
            }
        }
        return result;
    }

    private Insets getContainerGap(Container container, int sizeStyle) {
        Object gap = null;
        HashMap gapMap = containerGaps;
        String uid = container instanceof JComponent ? ((JComponent)container).getUIClassID() : (container instanceof Dialog ? "Dialog" : (container instanceof Frame ? "Frame" : (container instanceof Applet ? "Applet" : (container instanceof Panel ? "Panel" : "default"))));
        String style = null;
        String key = style == null ? uid : uid + "." + style;
        Insets[] gaps = (Insets[])gapMap.get(key);
        if (gaps == null) {
            gaps = (Insets[])gapMap.get(uid);
        }
        if (gaps == null) {
            gaps = (Insets[])gapMap.get("default");
        }
        if (gaps == null) {
            // empty if block
        }
        return gaps == null ? new Insets(0, 0, 0, 0) : (Insets)gaps[sizeStyle].clone();
    }

    private Insets getVisualMargin(JComponent component) {
        try {
            Method getUI = component.getClass().getMethod("getUI", new Class[0]);
            Object ui = getUI.invoke((Object)component, new Object[0]);
            if (ui instanceof VisuallyLayoutable) {
                Dimension size = component.getPreferredSize();
                Rectangle visualBounds = ((VisuallyLayoutable)ui).getVisualBounds(component, 1, size.width, size.height);
                return new Insets(visualBounds.y, visualBounds.x, size.height - visualBounds.y - visualBounds.height, size.width - visualBounds.x - visualBounds.width);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
        return new Insets(0, 0, 0, 0);
    }

    private Insets getVisualIndent(JComponent component) {
        try {
            Method getUI = component.getClass().getMethod("getUI", new Class[0]);
            Object ui = getUI.invoke((Object)component, new Object[0]);
            if (ui instanceof VisuallyLayoutable) {
                Dimension size = component.getPreferredSize();
                Rectangle visualBounds = ((VisuallyLayoutable)ui).getVisualBounds(component, 2, size.width, size.height);
                return new Insets(visualBounds.y, visualBounds.x, size.height - visualBounds.y - visualBounds.height, size.width - visualBounds.x - visualBounds.width);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
        return new Insets(0, 0, 0, 0);
    }

    private int getSizeStyle(Component c) {
        int fontSize = c.getFont().getSize();
        return fontSize >= 13 ? 2 : (fontSize > 9 ? 1 : 0);
    }
}

