/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxCellRenderer;
import ch.randelshofer.quaqua.QuaquaComboBoxUI;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class QuaquaComboPopup
extends BasicComboPopup {
    private QuaquaComboBoxUI qqui;

    public QuaquaComboPopup(JComboBox cBox, QuaquaComboBoxUI qqui) {
        super(cBox);
        this.qqui = qqui;
        this.updateCellRenderer(qqui.isTableCellEditor());
    }

    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
        this.list.repaint();
    }

    private void updateCellRenderer(boolean isTableCellEditor) {
        this.list.setCellRenderer(new QuaquaComboBoxCellRenderer(this.comboBox.getRenderer(), isTableCellEditor, this.comboBox.isEditable()));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicComboPopup.PropertyChangeHandler(){

            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                String propertyName = e.getPropertyName();
                JComboBox comboBox = (JComboBox)e.getSource();
                if (propertyName.equals("renderer") || propertyName.equals("JComboBox.isTableCellEditor")) {
                    QuaquaComboPopup.this.updateCellRenderer(e.getNewValue().equals(Boolean.TRUE));
                } else if (propertyName.equals("JComboBox.lightweightKeyboardNavigation")) {
                    QuaquaComboPopup.this.updateCellRenderer(e.getNewValue() != null && e.getNewValue().equals("Lightweight"));
                } else if (propertyName.equals("editable")) {
                    QuaquaComboPopup.this.updateCellRenderer(QuaquaComboPopup.this.isTableCellEditor());
                }
            }
        };
    }

    private int getMaximumRowCount() {
        return this.isEditable() || this.isTableCellEditor() ? this.comboBox.getMaximumRowCount() : 100;
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        boolean isSmall;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int listWidth = this.getList().getPreferredSize().width;
        Insets margin = this.qqui.getMargin();
        boolean isTableCellEditor = this.isTableCellEditor();
        boolean hasScrollBars = this.hasScrollBars();
        boolean isEditable = this.isEditable();
        boolean bl = isSmall = this.comboBox.getFont().getSize() <= 11;
        if (isTableCellEditor) {
            pw = hasScrollBars ? Math.max(pw, listWidth + 16) : Math.max(pw, listWidth);
        } else if (hasScrollBars) {
            px += margin.left;
            pw = Math.max(pw - margin.left - margin.right, listWidth + 16);
        } else if (isEditable) {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        } else {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        }
        GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.comboBox);
        if (gc != null) {
            Insets screenInsets;
            try {
                screenInsets = (Insets)Toolkit.class.getMethod("getScreenInsets", GraphicsConfiguration.class).invoke((Object)toolkit, gc);
            }
            catch (Exception e) {
                screenInsets = new Insets(22, 0, 0, 0);
            }
            screenBounds = new Rectangle(gc.getBounds());
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        if (this.isDropDown()) {
            if (!isTableCellEditor) {
                py = isEditable ? (py -= margin.bottom + 2) : (py -= margin.bottom);
            }
        } else {
            int yOffset = isTableCellEditor ? 7 : 3 - margin.top;
            int selectedIndex = this.comboBox.getSelectedIndex();
            py = selectedIndex <= 0 ? -yOffset : -yOffset - this.list.getCellBounds((int)0, (int)(selectedIndex - 1)).height;
        }
        Rectangle rect = new Rectangle(px, Math.max(py, p.y + screenBounds.y), Math.min(screenBounds.width, pw), Math.min(screenBounds.height - 40, ph));
        if (rect.height < ph) {
            rect.width += 16;
        }
        return rect;
    }

    private boolean isDropDown() {
        return this.comboBox.isEditable() || this.hasScrollBars();
    }

    private boolean hasScrollBars() {
        return this.comboBox.getModel().getSize() > this.getMaximumRowCount();
    }

    private boolean isEditable() {
        return this.comboBox.isEditable();
    }

    private boolean isTableCellEditor() {
        return this.qqui.isTableCellEditor();
    }

    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(UIManager.getBorder("PopupMenu.border"));
    }

    protected void configureList() {
        super.configureList();
        this.list.setBackground(UIManager.getColor("PopupMenu.background"));
    }
}

