/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFPage;
import com.infocom.print.PFPageFormat;
import com.infocom.print.PFPageSetupDialog;
import com.infocom.print.PFPrintObject;
import com.infocom.print.PFPrintPreview;
import java.awt.print.Book;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.util.Vector;

public class PFDocument {
    private Vector pageCollection = new Vector();
    private String documentName = "";
    private String exportFilename = "";
    private boolean showPrintDialog = false;
    private boolean showPageDialog = false;
    private PFPrintObject header = null;
    private PFPrintObject footer = null;
    private PFPrintObject firstPageHeader = null;
    private PFPrintObject firstPageFooter = null;

    public void addPage(PFPage pFPage) {
        if (pFPage != null) {
            this.pageCollection.add(pFPage);
            pFPage.setDocument(this);
        }
    }

    public void addPage(PFPage pFPage, int n) {
        if (pFPage != null) {
            this.pageCollection.insertElementAt(pFPage, n);
            pFPage.setDocument(this);
        }
    }

    public void removePage(int n) {
        if (n >= 0 && n < this.pageCollection.size()) {
            this.pageCollection.remove(n);
        }
    }

    public void removePage(PFPage pFPage) {
        if (pFPage != null) {
            this.pageCollection.remove(pFPage);
        }
    }

    public PFPage getPage(int n) {
        if (n >= 0 && n < this.pageCollection.size()) {
            return (PFPage)this.pageCollection.get(n);
        }
        return null;
    }

    public int getPageCount() {
        return this.pageCollection.size();
    }

    public void setDocumentName(String string) {
        this.documentName = string;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void showPrintDialog(boolean bl) {
        this.showPrintDialog = bl;
    }

    public void showPageDialog(boolean bl) {
        this.showPageDialog = bl;
    }

    public void print() {
        this.print(0, this.pageCollection.size());
    }

    public void print(int n, int n2) {
        Object object;
        PFPageFormat pFPageFormat = new PFPageFormat();
        if (n2 > this.pageCollection.size()) {
            n2 = this.pageCollection.size();
        }
        if (n < 0) {
            n = 0;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(this.documentName);
        if (this.showPageDialog) {
            object = new PFPageSetupDialog(pFPageFormat);
            pFPageFormat = ((PFPageSetupDialog)object).showDialog();
        }
        object = new Book();
        for (int i = n; i < n2; ++i) {
            PFPage pFPage = (PFPage)this.pageCollection.get(i);
            if (this.showPageDialog) {
                ((Book)object).append(pFPage, pFPageFormat.getPageFormat());
                continue;
            }
            ((Book)object).append(pFPage, pFPage.getPageFormat().getPageFormat());
        }
        printerJob.setPageable((Pageable)object);
        try {
            if (this.showPrintDialog) {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            } else {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printPDF(String string) {
    }

    public void printHTML(String string) {
    }

    public void printPreview() {
        PFPrintPreview pFPrintPreview = new PFPrintPreview(this);
    }

    public void setHeader(PFPrintObject pFPrintObject) {
        this.header = pFPrintObject;
    }

    public void setFooter(PFPrintObject pFPrintObject) {
        this.footer = pFPrintObject;
    }

    public void setFirstPageHeader(PFPrintObject pFPrintObject) {
        this.firstPageHeader = pFPrintObject;
    }

    public void setFirstPageFooter(PFPrintObject pFPrintObject) {
        this.firstPageFooter = pFPrintObject;
    }

    public PFPrintObject getHeader() {
        return this.header;
    }

    public PFPrintObject getFooter() {
        return this.footer;
    }

    public PFPrintObject getHeader(PFPage pFPage) {
        if (this.getPageNo(pFPage) == 0 && this.firstPageHeader != null) {
            return this.firstPageHeader;
        }
        return this.header;
    }

    public PFPrintObject getFooter(PFPage pFPage) {
        if (this.getPageNo(pFPage) == 0 && this.firstPageFooter != null) {
            return this.firstPageFooter;
        }
        return this.footer;
    }

    public int getPageNo(PFPage pFPage) {
        return this.pageCollection.indexOf(pFPage);
    }
}

