/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import com.informagen.FilterByMacOSType;
import com.informagen.Sequence;
import com.informagen.SequenceFile;
import com.informagen.swing.ExtensionFileFilter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class DNAStriderFile
extends SequenceFile {
    private DataInputStream stream = null;
    private static FileFilter fileFilter = null;

    public DNAStriderFile() {
    }

    public DNAStriderFile(File file) {
        super(file);
    }

    public FileFilter getFileFilter() {
        if (fileFilter != null) {
            return fileFilter;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            fileFilter = new FilterByMacOSType();
            ((FilterByMacOSType)fileFilter).addSignature("D@Sr", "xDNA");
            ((FilterByMacOSType)fileFilter).addSignature("D@Sr", "xRNA");
            ((FilterByMacOSType)fileFilter).addSignature("D@Sr", "xPRT");
            ((FilterByMacOSType)fileFilter).setDescription("DNA Strider");
        } else {
            fileFilter = new ExtensionFileFilter();
            ((ExtensionFileFilter)fileFilter).addExtension("seq");
            ((ExtensionFileFilter)fileFilter).addExtension("pro");
            ((ExtensionFileFilter)fileFilter).setDescription("DNA Strider");
        }
        return fileFilter;
    }

    public void close() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Sequence read() {
        Sequence sequence = new Sequence();
        sequence.setUID(StringUtils.substringBefore(this.file.getName(), "."));
        sequence.setTitle("DNA Strider file: " + this.file.getName());
        try {
            this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            this.stream.skip(28L);
            int n = this.stream.readInt();
            this.stream.skip(80L);
            byte[] byArray = new byte[n];
            this.stream.read(byArray);
            sequence.setSequence(new String(byArray));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sequence;
    }

    public void write(Sequence sequence) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string = sequence.getSequence();
            if (string == null) {
                string = "";
            }
            byte[] byArray = new byte[112];
            dataOutputStream.write(byArray, 0, 28);
            dataOutputStream.writeInt(string.length());
            dataOutputStream.write(byArray, 32, 80);
            dataOutputStream.writeBytes(string);
            dataOutputStream.flush();
            dataOutputStream.close();
            MRJAdapter.setFileCreator(this.file, "D@Sr");
            if (sequence.isDNA()) {
                MRJAdapter.setFileType(this.file, "xDNA");
            } else if (sequence.isRNA()) {
                MRJAdapter.setFileType(this.file, "xRNA");
            } else if (sequence.isProtein()) {
                MRJAdapter.setFileType(this.file, "xPRT");
            } else {
                MRJAdapter.setFileType(this.file, "xDNA");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

