/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import com.informagen.Sequence;
import com.informagen.SequenceFile;
import com.informagen.sa.format.Raw;
import com.informagen.swing.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.lang.StringUtils;

public class RAWFile
extends SequenceFile {
    private static FileFilter fileFilter;
    private static int[] seqCharSet;

    public FileFilter getFileFilter() {
        if (fileFilter != null) {
            return fileFilter;
        }
        fileFilter = new ExtensionFileFilter();
        ((ExtensionFileFilter)fileFilter).addExtension("raw");
        ((ExtensionFileFilter)fileFilter).addExtension("seq");
        ((ExtensionFileFilter)fileFilter).setDescription("Sequence only");
        return fileFilter;
    }

    public RAWFile() {
    }

    public RAWFile(File file) {
        super(file);
    }

    public Sequence read() {
        Sequence sequence = new Sequence();
        sequence.setUID(StringUtils.substringBefore(this.file.getName(), "."));
        sequence.setTitle("Sequence only file: " + this.file.getName());
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            this.reader = new BufferedReader(new FileReader(this.file));
            block5: while ((n = this.reader.read()) != -1) {
                switch (seqCharSet[n & 0x7F]) {
                    case -1: {
                        continue block5;
                    }
                }
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sequence.setSequence(stringBuffer.toString());
        return sequence;
    }

    public void write(Sequence sequence) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            String string = sequence.getSequence();
            if (string != null) {
                Raw raw = new Raw();
                raw.setSequence(string);
                fileOutputStream.write(raw.format().getBytes());
            }
            fileOutputStream.close();
            MRJAdapter.setFileType(this.file, "TEXT");
            MRJAdapter.setFileCreator(this.file, "R*ch");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        seqCharSet = new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, 75, 76, 77, 78, -1, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, 107, 108, 109, 110, -1, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1};
    }
}

