/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;

public class StateMonitor {
    Vector states = new Vector();
    Hashtable associations = new Hashtable();
    Hashtable componentCounts = new Hashtable();

    public void associate(Component component, Object object) {
        component.setEnabled(false);
        Vector<Component> vector = (Vector<Component>)this.associations.get(object);
        if (vector == null) {
            vector = new Vector<Component>();
        }
        if (!vector.contains(component)) {
            vector.addElement(component);
        }
        this.associations.put(object, vector);
        if (this.states.contains(object)) {
            Integer n = this.updateCount(component, 1);
            if (n == 1) {
                component.setEnabled(true);
            }
            this.componentCounts.put(component, n);
        }
    }

    public void disassociate(Component component, Object object) {
        Vector vector = (Vector)this.associations.get(object);
        if (vector == null) {
            return;
        }
        if (vector.contains(component)) {
            vector.removeElement(component);
            Integer n = this.updateCount(component, -1);
            if (n == 0) {
                component.setEnabled(false);
            }
            this.componentCounts.put(component, n);
        }
    }

    public void changeState(Object object, boolean bl) {
        if (bl) {
            this.enterState(object);
        } else {
            this.exitState(object);
        }
    }

    public void enterState(Object object) {
        if (!this.states.contains(object)) {
            this.states.addElement(object);
            this.update(object, true);
        }
    }

    public void exitState(Object object) {
        if (this.states.contains(object)) {
            this.states.removeElement(object);
            this.update(object, false);
        }
    }

    private void update(Object object, boolean bl) {
        int n = bl ? 1 : -1;
        Vector vector = (Vector)this.associations.get(object);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Component component = (Component)vector.elementAt(i);
            Integer n2 = this.updateCount(component, n);
            if (n2 == 0) {
                component.setEnabled(false);
            } else if (n2 == 1 && bl) {
                component.setEnabled(true);
            }
            this.componentCounts.put(component, n2);
        }
    }

    private Integer updateCount(Component component, int n) {
        Integer n2 = (Integer)this.componentCounts.get(component);
        int n3 = n;
        if (n2 != null) {
            n3 += n2.intValue();
        }
        n3 = n3 < 0 ? 0 : n3;
        return new Integer(n3);
    }
}

