/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.GIVEntityResolver;
import com.informagen.giv.GIVXMLHandler;
import com.informagen.giv.MapView;
import com.informagen.giv.SAXErrorHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLFormat {
    private static MapView mapView;
    private static String xmlSource;

    public static MapView create(File file) {
        mapView = null;
        xmlSource = file.getName();
        try {
            FileReader fileReader = new FileReader(file);
            mapView = XMLFormat.create(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not Found:  " + fileNotFoundException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            System.out.println("I/O Error:  " + iOException.getMessage());
            return null;
        }
        return mapView;
    }

    public static MapView create(URL uRL) throws IOException {
        xmlSource = uRL.toString();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        mapView = XMLFormat.create(bufferedReader);
        return mapView;
    }

    public static MapView create(Reader reader) throws IOException {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setErrorHandler(new SAXErrorHandler(System.err));
            xMLReader.setEntityResolver(new GIVEntityResolver());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        MapView mapView = new MapView();
        try {
            GIVXMLHandler gIVXMLHandler = new GIVXMLHandler(mapView);
            xMLReader.setContentHandler(gIVXMLHandler);
            InputSource inputSource = new InputSource(reader);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException("Fatal SAX Error:  " + sAXException.getMessage());
        }
        return mapView;
    }

    static {
        xmlSource = null;
    }
}

