/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.pI;

import com.informagen.Sequence;
import com.informagen.sa.composition.Composition;

public class IsoElectricPoint {
    private static final int C = 1;
    private static final int D = 2;
    private static final int E = 3;
    private static final int H = 6;
    private static final int K = 8;
    private static final int R = 14;
    private static final int S = 15;
    private static final int T = 16;
    private static final int Y = 19;

    public static double calculateIsoelectric(double[][] dArray) {
        double d = Double.NaN;
        if (dArray == null) {
            return d;
        }
        if (dArray.length > 1 && dArray[0][1] > 0.0 && dArray[dArray.length - 1][1] < 0.0) {
            double d2 = dArray[0][0];
            double d3 = dArray[0][1];
            int n = 1;
            while (dArray[n][1] > 0.0) {
                d2 = dArray[n][0];
                d3 = dArray[n][1];
                ++n;
            }
            double d4 = dArray[n][0] - d2;
            double d5 = dArray[n][1] - d3;
            try {
                d = d2 - d3 * d4 / d5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public static double[][] pIData(Sequence sequence, int[] nArray, double d, double d2, double d3) {
        int n;
        String string = sequence.getSequence().toUpperCase();
        if (nArray != null) {
            string = string.substring(nArray[0], nArray[1]);
        }
        char[] cArray = string.toCharArray();
        int[] nArray2 = new int[21];
        for (n = 0; n < cArray.length; ++n) {
            int n2 = Composition.aa2num(cArray[n]);
            nArray2[n2] = nArray2[n2] + 1;
        }
        n = (int)((d2 - d) / d3) + 1;
        double[][] dArray = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double d4;
            dArray[i][0] = d4 = d + d3 * (double)i;
            dArray[i][1] = IsoElectricPoint.pH(d4, nArray2);
        }
        return dArray;
    }

    static double pH(double d, int[] nArray) {
        double d2 = Math.pow(10.0, d);
        double d3 = 0.0;
        double d4 = 8.0;
        int n = 0;
        int n2 = 1;
        double d5 = d2 / Math.pow(10.0, d4);
        double d6 = d5 / (1.0 + d5);
        double d7 = (double)(n * n2) * d6;
        double d8 = 1.0 / d5;
        double d9 = d8 / (1.0 + d8);
        double d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 3.65;
        n = -1;
        n2 = nArray[2];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 4.25;
        n = -1;
        n2 = nArray[3];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 6.0;
        n = 0;
        n2 = nArray[6];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 10.29;
        n = -1;
        n2 = nArray[1];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 10.06;
        n = -1;
        n2 = nArray[19];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 10.52;
        n = 0;
        n2 = nArray[8];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 12.48;
        n = 0;
        n2 = nArray[14];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 13.6;
        n = -1;
        n2 = nArray[15];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 13.6;
        n = -1;
        n2 = nArray[16];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 3.1;
        n = -1;
        n2 = 1;
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        return d3 += d7 + d10;
    }
}

