/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.pairwise;

import com.informagen.F;
import com.informagen.Sequence;
import com.informagen.StateMonitor;
import com.informagen.Util;
import com.informagen.report.GappedSequenceMember;
import com.informagen.report.LayoutMember;
import com.informagen.report.ReportLayout;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.ComparisonTable;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import neobio.alignment.BasicScoringScheme;
import neobio.alignment.CrochemoreLandauZivUkelsonGlobalAlignment;
import neobio.alignment.CrochemoreLandauZivUkelsonLocalAlignment;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidScoringMatrixException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.NeedlemanWunsch;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;
import neobio.alignment.ScoringMatrix;
import neobio.alignment.ScoringScheme;
import neobio.alignment.SmithWaterman;
import org.apache.commons.lang.StringUtils;

public class PairwisePanel
extends AnalysisPanel {
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private final StateMonitor stateMonitor = new StateMonitor();
    final JComboBox methodComboBox = new JComboBox();
    final JComboBox tableComboBox = new JComboBox();
    final JTextField matchFld = new JTextField("1", 4);
    final JTextField mismatchFld = new JTextField("-1", 4);
    final JTextField gapFld = new JTextField("-1", 4);
    JComboBox vsSequenceComboBox = new JComboBox();
    final JButton useDefaultsBtn = new JButton("Use Defaults");
    final JButton doAlignmentBtn = new JButton("Do Alignment");
    ByteArrayOutputStream mOutputStr;
    JTextArea outputArea = new JTextArea(80, 80);
    Sequence sequence;
    int[] selection;
    Sequence vsSequence;
    boolean threadIsRunning = false;

    public static String getAnalysisName() {
        return "Pairwise";
    }

    public PairwisePanel() {
        this.buildUI();
        this.wireUI();
        this.matchFld.setText(Integer.toString(this.preferences.getInt("match", 1)));
        this.mismatchFld.setText(Integer.toString(this.preferences.getInt("mismatch", -1)));
        this.gapFld.setText(Integer.toString(this.preferences.getInt("gap", -1)));
        this.methodComboBox.setSelectedItem(this.preferences.get("method", "Needleman & Wunsch (global)"));
        this.tableComboBox.setSelectedItem(this.preferences.get("table", "Match/Mismatch/Gap"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("sequenceAdded")) {
            SAObject sAObject = (SAObject)propertyChangeEvent.getNewValue();
            this.addSequence(sAObject);
        } else if (string.equals("sequenceRemoved")) {
            SAObject sAObject = (SAObject)propertyChangeEvent.getNewValue();
            this.removeSequence(sAObject);
        }
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.stateMonitor.changeState("okToAlign", this.checkState());
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.sequence = null;
        this.selection = null;
        this.writeToOutputArea("");
        this.stateMonitor.changeState("okToAlign", false);
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.stateMonitor.changeState("okToAlign", this.checkState());
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
    }

    public void selectionCancelled() {
        this.selection = null;
    }

    public void cursorPositionChanged(int n) {
    }

    public void printPanel() {
        String string = this.outputArea.getText();
        PanelPrinter panelPrinter = new PanelPrinter(string);
        panelPrinter.setPointSize(10);
        panelPrinter.print();
    }

    public void savePanel() {
        String string = this.sequence != null ? this.sequence.getUID() : "";
        String string2 = this.vsSequence != null ? this.vsSequence.getUID() : "";
        String string3 = string + " vs " + string2;
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, this.outputArea.getText(), string3 + ".txt");
    }

    private boolean checkState() {
        if (this.sequence == null || this.vsSequence == null) {
            return false;
        }
        return this.sequence.getType() == this.vsSequence.getType();
    }

    void buildUI() {
        this.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createChoices());
        jPanel.add(this.createParameters());
        jPanel.add(this.createVersusChoice());
        jPanel.add(this.createButtons());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add(this.createAlignmentArea(), "Center");
    }

    void wireUI() {
        this.stateMonitor.associate(this.doAlignmentBtn, "okToAlign");
        this.methodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.tableComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwisePanel.this.adjustBasicFields(PairwisePanel.this.tableComboBox.getSelectedIndex() == 0);
            }
        });
        this.vsSequenceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwisePanel.this.setVsSequence(PairwisePanel.this.vsSequenceComboBox.getSelectedIndex());
            }
        });
        this.useDefaultsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwisePanel.this.doDefaults();
            }
        });
        this.doAlignmentBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwisePanel.this.doAlignment();
            }
        });
        this.useDefaultsBtn.setToolTipText("Button to reset defaults");
        this.doAlignmentBtn.setToolTipText("Button to initiate alignment");
    }

    JPanel createChoices() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.methodComboBox.addItem("Needleman & Wunsch (global)");
        this.methodComboBox.addItem("Smith & Waterman (local)");
        this.methodComboBox.addItem("Crochemore, Landau & Ziv-Ukelson (global)");
        this.methodComboBox.addItem("Crochemore, Landau & Ziv-Ukelson (local)");
        jPanel.add(this.methodComboBox);
        this.tableComboBox.addItem("Match/Mismatch/Gap");
        this.tableComboBox.addItem("DNA Matrix");
        this.tableComboBox.addItem("PAM 30");
        this.tableComboBox.addItem("PAM 70");
        this.tableComboBox.addItem("PAM 250");
        this.tableComboBox.addItem("BLOSUM 45");
        this.tableComboBox.addItem("BLOSUM 62");
        this.tableComboBox.addItem("BLOSUM 80");
        jPanel.add(this.tableComboBox);
        return jPanel;
    }

    JPanel createParameters() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 10, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        JLabel jLabel = new JLabel("Match:");
        jPanel2.add(jLabel);
        jPanel2.add(this.matchFld);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jLabel = new JLabel("Mismatch:");
        jPanel2.add(jLabel);
        jPanel2.add(this.mismatchFld);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jLabel = new JLabel("Gap:");
        jPanel2.add(jLabel);
        jPanel2.add(this.gapFld);
        jPanel.add(jPanel2);
        return jPanel;
    }

    JPanel createVersusChoice() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel jLabel = new JLabel("Against Sequence:");
        jPanel.add(jLabel);
        jPanel.add(this.vsSequenceComboBox);
        return jPanel;
    }

    JPanel createButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.useDefaultsBtn);
        jPanel.add(this.doAlignmentBtn);
        return jPanel;
    }

    private void adjustBasicFields(boolean bl) {
        this.matchFld.setEnabled(bl);
        this.mismatchFld.setEnabled(bl);
        this.gapFld.setEnabled(bl);
    }

    private void setVsSequence(int n) {
        SAObject sAObject = (SAObject)this.vsSequenceComboBox.getItemAt(n);
        if (sAObject == null) {
            return;
        }
        this.vsSequence = sAObject.getSequence();
        this.stateMonitor.changeState("okToAlign", this.checkState());
    }

    Component createAlignmentArea() {
        this.outputArea.setFont(new Font("Courier", 0, Util.isWindows() ? 10 : 12));
        this.outputArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 22, 30);
        return jScrollPane;
    }

    void doDefaults() {
        this.methodComboBox.setSelectedIndex(0);
        this.tableComboBox.setSelectedIndex(0);
        this.matchFld.setText("1");
        this.mismatchFld.setText("-1");
        this.gapFld.setText("-1");
    }

    private void addSequence(SAObject sAObject) {
        this.vsSequenceComboBox.addItem(sAObject);
    }

    private void removeSequence(SAObject sAObject) {
        this.vsSequenceComboBox.removeItem(sAObject);
        this.stateMonitor.changeState("okToAlign", this.vsSequenceComboBox.getItemCount() != 0);
    }

    public void doAlignment() {
        this.preferences.putInt("match", Integer.parseInt(this.matchFld.getText()));
        this.preferences.putInt("mismatch", Integer.parseInt(this.mismatchFld.getText()));
        this.preferences.putInt("gap", Integer.parseInt(this.gapFld.getText()));
        this.preferences.put("method", (String)this.methodComboBox.getSelectedItem());
        this.preferences.put("table", (String)this.tableComboBox.getSelectedItem());
        if (!this.checkState()) {
            return;
        }
        this.stateMonitor.changeState("okToAlign", false);
        Thread thread = new Thread(){

            public void run() {
                PairwisePanel.this.threadIsRunning = true;
                PairwisePanel.this.align();
                PairwisePanel.this.stateMonitor.changeState("okToAlign", PairwisePanel.this.checkState());
                PairwisePanel.this.threadIsRunning = false;
            }
        };
        try {
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void align() {
        int n;
        long l;
        long l2;
        String string;
        System.gc();
        ScoringScheme scoringScheme = null;
        PairwiseAlignment pairwiseAlignment = null;
        PairwiseAlignmentAlgorithm pairwiseAlignmentAlgorithm = null;
        int n2 = this.methodComboBox.getSelectedIndex();
        int n3 = this.tableComboBox.getSelectedIndex();
        this.writeToOutputArea("");
        if (n3 == 0) {
            this.writeToOutputArea("Creating scoring scheme... ");
            try {
                int n4 = Integer.parseInt(this.matchFld.getText());
                int n5 = Integer.parseInt(this.mismatchFld.getText());
                int n6 = Integer.parseInt(this.gapFld.getText());
                scoringScheme = new BasicScoringScheme(n4, n5, n6);
                this.appendToOutputArea("OK");
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Invalid scoring arguments.";
                this.appendToOutputArea("\n" + string2);
                return;
            }
        }
        switch (n3) {
            default: {
                string = "/com/informagen/sa/pairwise/dnamatrix.txt";
                break;
            }
            case 2: {
                string = "/com/informagen/sa/pairwise/pam30.txt";
                break;
            }
            case 3: {
                string = "/com/informagen/sa/pairwise/pam70.txt";
                break;
            }
            case 4: {
                string = "/com/informagen/sa/pairwise/pam250.txt";
                break;
            }
            case 5: {
                string = "/com/informagen/sa/pairwise/blosum45.txt";
                break;
            }
            case 6: {
                string = "/com/informagen/sa/pairwise/blosum62.txt";
                break;
            }
            case 7: {
                string = "/com/informagen/sa/pairwise/blosum80.txt";
            }
        }
        Object object = this.getClass().getResourceAsStream(string);
        Object object2 = new InputStreamReader((InputStream)object);
        this.writeToOutputArea("Loading matrix file... ");
        try {
            try {
                scoringScheme = new ScoringMatrix((Reader)object2);
                this.appendToOutputArea("OK");
            }
            catch (InvalidScoringMatrixException invalidScoringMatrixException) {
                String string3 = "Invalid matrix file \"" + string + "\".";
                this.appendToOutputArea("\n" + string3);
                return;
            }
            finally {
                ((InputStreamReader)object2).close();
            }
        }
        catch (IOException iOException) {
            String string4 = "Error reading file.";
            this.appendToOutputArea("\n" + string4);
            return;
        }
        switch (n2) {
            case 0: {
                pairwiseAlignmentAlgorithm = new NeedlemanWunsch();
                break;
            }
            case 1: {
                pairwiseAlignmentAlgorithm = new SmithWaterman();
                break;
            }
            case 2: {
                pairwiseAlignmentAlgorithm = new CrochemoreLandauZivUkelsonGlobalAlignment();
                break;
            }
            case 3: {
                pairwiseAlignmentAlgorithm = new CrochemoreLandauZivUkelsonLocalAlignment();
            }
        }
        pairwiseAlignmentAlgorithm.setScoringScheme(scoringScheme);
        this.appendToOutputArea("\n\nLoading sequences... ");
        object = this.sequence.getSequence().toUpperCase();
        if (this.selection != null) {
            object = ((String)object).substring(this.selection[0], this.selection[1]);
        }
        StringReader stringReader = new StringReader((String)object);
        StringReader stringReader2 = new StringReader(this.vsSequence.getSequence().toUpperCase());
        try {
            try {
                l2 = System.currentTimeMillis();
                pairwiseAlignmentAlgorithm.loadSequences(stringReader, stringReader2);
                l = System.currentTimeMillis() - l2;
                this.appendToOutputArea("OK");
                this.appendToOutputArea("\n[ Elapsed time: " + l + " milliseconds ]");
            }
            catch (InvalidSequenceException invalidSequenceException) {
                String string5 = "Invalid sequence files.";
                this.appendToOutputArea("\n" + string5);
                return;
            }
            finally {
                stringReader.close();
                stringReader2.close();
            }
        }
        catch (IOException iOException) {
            String string6 = "Error reading sequence files.";
            this.appendToOutputArea("\n" + string6);
            return;
        }
        this.appendToOutputArea("\n\nRunning " + this.methodComboBox.getSelectedItem() + "... ");
        try {
            l2 = System.currentTimeMillis();
            pairwiseAlignment = pairwiseAlignmentAlgorithm.getPairwiseAlignment();
            l = System.currentTimeMillis() - l2;
            this.appendToOutputArea("OK");
            this.appendToOutputArea("\n[ Elapsed time: " + l + " milliseconds ]");
        }
        catch (IncompatibleScoringSchemeException incompatibleScoringSchemeException) {
            String string7 = "Scoring matrix is not compatible with loaded sequences.";
            this.appendToOutputArea("\n" + string7);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            scoringScheme = null;
            pairwiseAlignment = null;
            pairwiseAlignmentAlgorithm = null;
            System.gc();
            String string8 = "Insufficient memory to compute an alignment";
            this.appendToOutputArea("\n" + string8);
            return;
        }
        this.writeToOutputArea("");
        this.appendToOutputArea(this.sequence.getDescription());
        this.appendToOutputArea("\n       vs.\n");
        this.appendToOutputArea(this.vsSequence.getDescription());
        this.appendToOutputArea("\n\n------------------------------------------------------------------\n");
        this.appendToOutputArea((String)this.methodComboBox.getSelectedItem());
        if (n3 == 0) {
            this.appendToOutputArea("\n   Match: " + this.matchFld.getText() + "\n");
            this.appendToOutputArea("Mismatch: " + this.mismatchFld.getText() + "\n");
            this.appendToOutputArea("     Gap: " + this.gapFld.getText());
        }
        object2 = pairwiseAlignment.getGappedSequence1();
        String string9 = pairwiseAlignment.getScoreTagLine();
        String string10 = pairwiseAlignment.getGappedSequence2();
        int n7 = 1;
        int n8 = 1;
        switch (n2) {
            case 1: 
            case 3: {
                String string11 = StringUtils.replaceChars((String)object2, "-", null);
                n7 = StringUtils.indexOf(this.sequence.getSequence().toUpperCase(), string11) + 1;
                String string12 = StringUtils.replaceChars(string10, "-", null);
                n8 = StringUtils.indexOf(this.vsSequence.getSequence().toUpperCase(), string12) + 1;
                this.appendToOutputArea("\n\n    Local: ");
                this.appendToOutputArea(Integer.toString(n7));
                this.appendToOutputArea("-");
                this.appendToOutputArea(Integer.toString(n7 + string11.length() - 1));
                this.appendToOutputArea("...");
                this.appendToOutputArea(Integer.toString(n8));
                this.appendToOutputArea("-");
                this.appendToOutputArea(Integer.toString(n8 + string12.length() - 1));
                break;
            }
            case 0: 
            case 2: {
                if (this.selection == null) break;
                n7 = this.selection[0] + 1;
            }
        }
        this.appendToOutputArea("\n    Score: ");
        this.appendToOutputArea(F.f((Object)Integer.toString(pairwiseAlignment.getScore()), 5));
        double d = ComparisonTable.identity((String)object2, string10);
        this.appendToOutputArea("\n Identity: " + F.f(d, 5, 1) + "%");
        this.appendToOutputArea("\n\n");
        int n9 = Math.max(this.sequence.getLength(), this.vsSequence.getLength());
        int n10 = (int)Math.ceil(Math.log(n9) / Math.log(10.0));
        String string13 = this.sequence.getSequence();
        StringBuffer stringBuffer = new StringBuffer(((String)object2).length());
        int n11 = n7 - 1;
        for (n = 0; n < ((String)object2).length(); ++n) {
            if (((String)object2).charAt(n) == '-') {
                stringBuffer.append('-');
                continue;
            }
            stringBuffer.append(string13.charAt(n11++));
        }
        object2 = stringBuffer.toString();
        string13 = this.vsSequence.getSequence();
        stringBuffer = new StringBuffer(string10.length());
        n11 = n8 - 1;
        for (n = 0; n < string10.length(); ++n) {
            if (string10.charAt(n) == '-') {
                stringBuffer.append('-');
                continue;
            }
            stringBuffer.append(string13.charAt(n11++));
        }
        string10 = stringBuffer.toString();
        ReportLayout reportLayout = new ReportLayout();
        reportLayout.add(new GappedSequenceMember((String)object2, n7, n10));
        LayoutMember layoutMember = new LayoutMember(string9);
        layoutMember.setPrefix(F.f(" ", n10 + 1, (short)16));
        reportLayout.add(layoutMember);
        reportLayout.add(new GappedSequenceMember(string10, n8, n10));
        try {
            StringWriter stringWriter = new StringWriter(string9.length() * 3);
            int n12 = 60;
            for (int i = 0; i <= ((String)object2).length(); i += n12) {
                reportLayout.write(stringWriter, i, i + n12);
                stringWriter.write("\n\n");
            }
            this.appendToOutputArea(stringWriter.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.toTopOfOutputArea();
        scoringScheme = null;
        pairwiseAlignment = null;
        pairwiseAlignmentAlgorithm = null;
        System.gc();
    }

    void appendToOutputArea(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PairwisePanel.this.outputArea.append(string);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    void writeToOutputArea(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PairwisePanel.this.outputArea.selectAll();
                    PairwisePanel.this.outputArea.replaceSelection(string);
                    PairwisePanel.this.outputArea.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    void toTopOfOutputArea() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PairwisePanel.this.outputArea.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

