/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

public class Factor {
    protected Factor ancestor;
    protected Factor next;
    protected int serial_number;
    protected int length;
    protected char new_char;

    public Factor() {
        this.ancestor = null;
        this.next = null;
        this.serial_number = 0;
        this.length = 0;
        this.new_char = '\u0000';
    }

    public Factor(Factor factor, int n, char c) {
        this.ancestor = factor;
        this.serial_number = n;
        this.new_char = c;
        if (factor == null) {
            throw new IllegalArgumentException("Ancestor factor cannot be null.");
        }
        this.length = factor.length() + 1;
    }

    public void setNext(Factor factor) {
        this.next = factor;
    }

    public Factor getAncestor() {
        return this.ancestor;
    }

    public int getAncestorSerialNumber() {
        return this.ancestor.getSerialNumber();
    }

    public Factor getNext() {
        return this.next;
    }

    public int getSerialNumber() {
        return this.serial_number;
    }

    public int length() {
        return this.length;
    }

    public char getNewChar() {
        return this.new_char;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Factor factor = this;
        while (factor.getAncestor() != null) {
            stringBuffer.insert(0, factor.getNewChar());
            factor = factor.getAncestor();
        }
        return stringBuffer.toString();
    }
}

