/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.ui.analysis.TmfAnalysisViewOutput;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfAnalysisOutputElement
extends TmfProjectModelElement
implements IPropertySource2 {
    private static final String OUTPUT_PROPERTIES_CATEGORY = Messages.TmfAnalysisOutputElement_Properties;
    private final IAnalysisOutput fOutput;

    protected TmfAnalysisOutputElement(String name, IResource resource, TmfAnalysisElement parent, IAnalysisOutput output) {
        super(name, resource, parent);
        this.fOutput = output;
    }

    @Override
    public Image getIcon() {
        IViewDescriptor descr;
        if (this.fOutput instanceof TmfAnalysisViewOutput && (descr = PlatformUI.getWorkbench().getViewRegistry().find(((TmfAnalysisViewOutput)this.fOutput).getViewId())) != null) {
            Activator bundle = Activator.getDefault();
            String key = descr.getId();
            Image icon = bundle.getImageRegistry().get(key);
            if (icon == null) {
                icon = descr.getImageDescriptor().createImage();
                bundle.getImageRegistry().put(key, icon);
            }
            if (icon != null) {
                return icon;
            }
        }
        return TmfProjectModelIcons.DEFAULT_VIEW_ICON;
    }

    public void outputAnalysis() {
        ITmfProjectModelElement parent = this.getParent();
        if (parent instanceof TmfAnalysisElement) {
            ((TmfAnalysisElement)parent).activateParentTrace();
            this.fOutput.requestOutput();
        }
    }

    @Override
    protected void refreshChildren() {
    }

    IAnalysisOutput getOutput() {
        return this.fOutput;
    }

    public Object getEditableValue() {
        return null;
    }

    private Map<String, String> getOutpuProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        IAnalysisOutput output = this.fOutput;
        if (output instanceof TmfAnalysisViewOutput) {
            properties.put(Messages.TmfAnalysisOutputElement_ViewIdProperty, ((TmfAnalysisViewOutput)output).getViewId());
        }
        return properties;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Map<String, String> outputProperties = this.getOutpuProperties();
        if (!outputProperties.isEmpty()) {
            ArrayList<ReadOnlyTextPropertyDescriptor> propertyDescriptorArray = new ArrayList<ReadOnlyTextPropertyDescriptor>(outputProperties.size());
            for (Map.Entry<String, String> varName : outputProperties.entrySet()) {
                ReadOnlyTextPropertyDescriptor descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + '_' + varName.getKey(), varName.getKey());
                descriptor.setCategory(OUTPUT_PROPERTIES_CATEGORY);
                propertyDescriptorArray.add(descriptor);
            }
            return propertyDescriptorArray.toArray(new IPropertyDescriptor[outputProperties.size()]);
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        Map<String, String> properties = this.getOutpuProperties();
        String key = (String)id;
        if (properties.containsKey(key = key.substring(this.getName().length() + 1))) {
            String value = properties.get(key);
            return value;
        }
        return null;
    }

    public final void resetPropertyValue(Object id) {
    }

    public final void setPropertyValue(Object id, Object value) {
    }

    public final boolean isPropertyResettable(Object id) {
        return false;
    }

    public final boolean isPropertySet(Object id) {
        return false;
    }
}

