/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.launcher;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

class ProcessWrapper
extends Process {
    private Process wrappedProcess;
    private boolean hideInputStream;
    private boolean hideErrorStream;
    private byte[] buffer = new byte[0];
    private InputStream emptyInputStream = new ByteArrayInputStream(this.buffer);
    private Object waitForSync = new Object();
    private boolean streamsClosingIsAllowed = false;

    public ProcessWrapper(Process wrappedProcess, boolean hideInputStream, boolean hideErrorStream) {
        this.wrappedProcess = wrappedProcess;
        this.hideInputStream = hideInputStream;
        this.hideErrorStream = hideErrorStream;
    }

    @Override
    public void destroy() {
        this.wrappedProcess.destroy();
    }

    @Override
    public int exitValue() {
        return this.wrappedProcess.exitValue();
    }

    @Override
    public InputStream getErrorStream() {
        return this.hideErrorStream ? this.emptyInputStream : this.wrappedProcess.getErrorStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.hideInputStream ? this.emptyInputStream : this.wrappedProcess.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.wrappedProcess.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Object object = this.waitForSync;
        synchronized (object) {
            if (!this.streamsClosingIsAllowed) {
                this.waitForSync.wait();
            }
        }
        return this.wrappedProcess.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowStreamsClosing() {
        Object object = this.waitForSync;
        synchronized (object) {
            this.streamsClosingIsAllowed = true;
            this.waitForSync.notifyAll();
        }
    }
}

