/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ISignals;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.mi.service.command.IEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointChangedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIDetachedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalChangedEvent;

@ConfinedToDsfExecutor(value="fConnection#getExecutor")
public class CLIEventProcessor_7_0
implements IEventProcessor {
    private final ICommandControlService fCommandControl;

    public CLIEventProcessor_7_0(ICommandControlService connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        this.fCommandControl = connection;
        this.fCommandControl.addCommandListener((ICommandListener)this);
        this.fCommandControl.addEventListener((IEventListener)this);
    }

    @Override
    public void dispose() {
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.fCommandControl.removeEventListener((IEventListener)this);
    }

    public void commandSent(ICommandToken token) {
        if (token.getCommand() instanceof CLICommand) {
            this.processStateChanges((CLICommand)token.getCommand());
        } else if (token.getCommand() instanceof MIInterpreterExecConsole) {
            this.processStateChanges((MIInterpreterExecConsole)token.getCommand());
        }
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        if (token.getCommand() instanceof CLICommand) {
            this.processSettingChanges((CLICommand)token.getCommand());
        } else if (token.getCommand() instanceof MIInterpreterExecConsole) {
            this.processSettingChanges((MIInterpreterExecConsole)token.getCommand());
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void eventReceived(Object output) {
    }

    private void processStateChanges(CLICommand<? extends ICommandResult> cmd) {
        String operation = cmd.getOperation().trim();
        this.processStateChanges(0, operation);
    }

    private void processStateChanges(MIInterpreterExecConsole<? extends ICommandResult> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processStateChanges(0, operations[0]);
        }
    }

    private void processStateChanges(int token, String operation) {
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        int type = CLIEventProcessor_7_0.getSteppingOperationKind(operation);
    }

    private void processSettingChanges(CLICommand<?> cmd) {
        String operation = cmd.getOperation().trim();
        this.processSettingChanges(cmd.getContext(), 0, operation);
    }

    private void processSettingChanges(MIInterpreterExecConsole<?> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processSettingChanges(exec.getContext(), 0, operations[0]);
        }
    }

    private void processSettingChanges(IDMContext dmc, int token, String operation) {
        ICommandControlService.ICommandControlDMContext controlDmc;
        int indx = operation.indexOf(32);
        if (this.isSettingBreakpoint(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim()) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
            if (bpTargetDmc != null) {
                MIBreakpointChangedEvent event = new MIBreakpointChangedEvent(bpTargetDmc, 0);
                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
            }
        } else if (this.isSettingSignal(operation)) {
            ISignals.ISignalsDMContext signalDmc = (ISignals.ISignalsDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISignals.ISignalsDMContext.class);
            if (signalDmc != null) {
                MISignalChangedEvent event = new MISignalChangedEvent(signalDmc, "");
                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
            }
        } else if (this.isDetach(operation) && (controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class)) != null) {
            MIDetachedEvent event = new MIDetachedEvent(controlDmc, token);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    private static int getSteppingOperationKind(String operation) {
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.startsWith("ret") && "return".indexOf(operation) != -1) {
            type = 7;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    public static boolean isSteppingOperation(String operation) {
        int type = CLIEventProcessor_7_0.getSteppingOperationKind(operation);
        return type != -1;
    }

    private boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1) {
            isbreak = true;
        }
        return isbreak;
    }

    private boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    private boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    private boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }
}

