/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.autotools.core.AutotoolsNewMakeGenerator;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.remote.core.RemoteCommandLauncher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractAutotoolsHandler
extends AbstractHandler {
    private IContainer fContainer;
    public final String SHELL_COMMAND = "sh";

    protected abstract void run(Shell var1);

    protected Object execute1(ExecutionEvent event) {
        Object obj;
        IContainer container;
        ISelection k = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!k.isEmpty() && k instanceof IStructuredSelection && (container = this.getContainer(obj = ((IStructuredSelection)k).getFirstElement())) != null) {
            this.setSelectedContainer(container);
            this.run(HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        return null;
    }

    protected IContainer getContainer(Object obj) {
        Collection c;
        Object[] objArray;
        IContainer fContainer = null;
        if (obj instanceof Collection && (objArray = (c = (Collection)obj).toArray()).length > 0) {
            obj = objArray[0];
        }
        if (obj instanceof ICElement) {
            if (obj instanceof ICContainer || obj instanceof ICProject) {
                fContainer = (IContainer)((ICElement)obj).getUnderlyingResource();
            } else if ((obj = ((ICElement)obj).getResource()) != null) {
                fContainer = ((IResource)obj).getParent();
            }
        } else {
            fContainer = obj instanceof IResource ? (obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent()) : null;
        }
        return fContainer;
    }

    protected void showError(String title, String content) {
        MessageDialog.openError((Shell)new Shell(), (String)title, (String)content);
    }

    protected List<String> separateTargets(String rawArgList) {
        StringTokenizer st = new StringTokenizer(rawArgList, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            StringBuilder tmpTarget;
            String currentWord = st.nextToken().trim();
            if (currentWord.startsWith("'")) {
                tmpTarget = new StringBuilder();
                while (!currentWord.endsWith("'")) {
                    tmpTarget.append(currentWord).append(' ');
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            if (currentWord.startsWith("\"")) {
                tmpTarget = new StringBuilder();
                while (!currentWord.endsWith("\"")) {
                    tmpTarget.append(currentWord).append(' ');
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            targetList.add(currentWord);
        }
        return targetList;
    }

    protected List<String> separateOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        rawArgList = rawArgList.trim();
        boolean finished = false;
        int lastIndex = rawArgList.indexOf("--");
        if (lastIndex != -1) {
            while (!finished) {
                int index = rawArgList.indexOf("--", lastIndex + 2);
                if (index != -1) {
                    String previous = rawArgList.substring(lastIndex, index).trim();
                    argList.add(previous);
                    rawArgList = rawArgList.substring(index);
                    continue;
                }
                argList.add(rawArgList);
                finished = true;
            }
        }
        return argList;
    }

    protected List<String> simpleParseOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        int lastArgIndex = -1;
        int i = 0;
        while (i < rawArgList.length()) {
            char ch = rawArgList.charAt(i);
            while (Character.isWhitespace(ch)) {
                if (++i < rawArgList.length()) {
                    ch = rawArgList.charAt(i);
                    continue;
                }
                return argList;
            }
            lastArgIndex = i;
            boolean inString = false;
            while (i < rawArgList.length()) {
                ch = rawArgList.charAt(i);
                if (ch == '\\') {
                    ++i;
                } else if (ch == '\"') {
                    inString = !inString;
                } else if (Character.isWhitespace(ch) && !inString) {
                    argList.add(rawArgList.substring(lastArgIndex, i));
                    break;
                }
                ++i;
            }
            if (i >= rawArgList.length()) {
                argList.add(rawArgList.substring(lastArgIndex));
            }
            ++i;
        }
        return argList;
    }

    protected IPath getExecDir(IContainer container) {
        int type = container.getType();
        IPath execDir = null;
        execDir = type == 1 ? container.getLocation().removeLastSegments(1) : container.getLocation();
        return execDir;
    }

    protected IPath getCWD(IContainer container) {
        int type = container.getType();
        IPath cwd = null;
        cwd = type == 1 ? container.getFullPath().removeLastSegments(1) : container.getFullPath();
        return cwd;
    }

    protected void executeConsoleCommand(String actionName, String command, List<String> argumentList, IPath execDir) {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job backgroundJob = Job.create((String)actionName, arg_0 -> this.lambda$0(actionName, execDir, command, argumentList, (ISchedulingRule)rule, arg_0));
        backgroundJob.setRule((ISchedulingRule)rule);
        backgroundJob.schedule();
    }

    protected IContainer getSelectedContainer() {
        return this.fContainer;
    }

    public void setSelectedContainer(IContainer container) {
        this.fContainer = container;
    }

    private /* synthetic */ IStatus lambda$0(String string, IPath iPath, String string2, List list, ISchedulingRule iSchedulingRule, IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().run(monitor1 -> {
                try {
                    String runInContainerProperty;
                    String errMsg = null;
                    IProject project = this.getSelectedContainer().getProject();
                    IConsole console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.autotools.ui.autotoolsConsole");
                    console.start(project);
                    CUIPlugin.getDefault().startGlobalConsole();
                    ConsoleOutputStream consoleOutStream = console.getOutputStream();
                    IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                    IConfiguration cfg = info.getDefaultConfiguration();
                    StringBuilder buf = new StringBuilder();
                    String[] consoleHeader = new String[]{string, cfg.getName(), project.getName()};
                    buf.append(System.getProperty("line.separator", "\n"));
                    String invokeMsg = InvokeMessages.getFormattedString("InvokeAction.console.message", new String[]{string, iPath.toString()});
                    buf.append(invokeMsg);
                    buf.append(System.getProperty("line.separator", "\n"));
                    buf.append(System.getProperty("line.separator", "\n"));
                    consoleOutStream.write(buf.toString().getBytes());
                    consoleOutStream.flush();
                    ArrayList additionalEnvs = new ArrayList();
                    String strippedCommand = AutotoolsNewMakeGenerator.stripEnvVars((String)string2, additionalEnvs);
                    IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
                    boolean runInContainer = false;
                    if (props != null && (runInContainerProperty = props.getProperty("org.eclipse.cdt.autotools.core.property.launchAutotoolsInContainer")) != null) {
                        runInContainer = Boolean.parseBoolean(runInContainerProperty);
                    }
                    CommandLauncher fallbackLauncher = runInContainer ? CommandLauncherManager.getInstance().getCommandLauncher(project) : new CommandLauncher();
                    RemoteCommandLauncher launcher = new RemoteCommandLauncher((ICommandLauncher)fallbackLauncher);
                    launcher.setProject(project);
                    IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
                    String[] env = null;
                    ArrayList<String> envList = new ArrayList<String>();
                    if (variables != null) {
                        int i = 0;
                        while (i < variables.length) {
                            envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                            ++i;
                        }
                        if (additionalEnvs.size() > 0) {
                            envList.addAll(additionalEnvs);
                        }
                        env = envList.toArray(new String[envList.size()]);
                    }
                    StringBuilder command1 = new StringBuilder(strippedCommand);
                    for (String arg : list) {
                        command1.append(' ').append(arg);
                    }
                    String[] newArgumentList = new String[]{"-c", command1.toString()};
                    ConsoleOutputStream stdout = consoleOutStream;
                    ConsoleOutputStream stderr = consoleOutStream;
                    launcher.showCommand(true);
                    Process proc = launcher.execute((IPath)new Path("sh"), newArgumentList, env, iPath, (IProgressMonitor)new NullProgressMonitor());
                    if (proc != null) {
                        try {
                            proc.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor1)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor1.subTask(AutotoolsUIPlugin.getResourceString("MakeGenerator.refresh"));
                        try {
                            project.refreshLocal(2, null);
                        }
                        catch (CoreException e2) {
                            monitor1.subTask(AutotoolsUIPlugin.getResourceString("MakeGenerator.refresh.error"));
                        }
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    if (errMsg != null) {
                        AutotoolsUIPlugin.logErrorMessage(errMsg);
                    }
                }
                catch (IOException e3) {
                    AutotoolsUIPlugin.log(e3);
                }
            }, iSchedulingRule, 1, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

