/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.BaseDataManipulator;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.model.PMStatEntry;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

public class StatComparisonData
extends BaseDataManipulator
implements IPerfData {
    private IPath oldFile;
    private IPath newFile;
    private String result = "";
    private String title;
    private String dataID;

    public StatComparisonData(String title, IPath oldFile, IPath newFile) {
        this.title = title;
        this.oldFile = oldFile;
        this.newFile = newFile;
        this.dataID = String.valueOf(new Date().getTime());
    }

    @Override
    public String getPerfData() {
        return this.result;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getDataID() {
        return this.dataID;
    }

    private String generateFileID(IPath file) {
        return String.valueOf(file.toOSString()) + this.dataID;
    }

    public String getOldDataPath() {
        return this.oldFile.toPortableString();
    }

    public String getNewDataPath() {
        return this.newFile.toOSString();
    }

    public String getOldDataID() {
        return this.generateFileID(this.oldFile);
    }

    public String getNewDataID() {
        return this.generateFileID(this.newFile);
    }

    public void runComparison() {
        ArrayList<PMStatEntry> statsDiff = this.getComparisonStats();
        if (!statsDiff.isEmpty()) {
            String[][] statsDiffStr = new String[statsDiff.size()][];
            int currentRow = 0;
            for (PMStatEntry statEntry : statsDiff) {
                statsDiffStr[currentRow] = statEntry.toStringArray();
                ++currentRow;
            }
            String format = this.getFormat(statsDiffStr);
            String[][] stringArray = statsDiffStr;
            int n = statsDiffStr.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] statEntry = stringArray[n2];
                String curLine = String.format(format, statEntry);
                curLine = curLine.contains("seconds time elapsed") ? "\n" + curLine : curLine;
                this.result = String.valueOf(this.result) + curLine;
                ++n2;
            }
        }
    }

    public ArrayList<PMStatEntry> getComparisonStats() {
        ArrayList<PMStatEntry> oldStats = StatComparisonData.collectStats(this.oldFile);
        ArrayList<PMStatEntry> newStats = StatComparisonData.collectStats(this.newFile);
        ArrayList<PMStatEntry> result = new ArrayList<PMStatEntry>();
        for (PMStatEntry oldEntry : oldStats) {
            for (PMStatEntry newEntry : newStats) {
                if (!oldEntry.equalEvents(newEntry)) continue;
                result.add(oldEntry.compare(newEntry));
            }
        }
        return result;
    }

    private static ArrayList<PMStatEntry> collectStats(IPath file) {
        ArrayList<PMStatEntry> result = new ArrayList<PMStatEntry>();
        BufferedReader statReader = null;
        URI fileURI = null;
        try {
            String line;
            fileURI = new URI(file.toPortableString());
            IRemoteFileProxy proxy = null;
            proxy = RemoteProxyManager.getInstance().getFileProxy(fileURI);
            IFileStore newDataFileStore = proxy.getResource(fileURI.getPath());
            statReader = new BufferedReader(new InputStreamReader(newDataFileStore.openInputStream(0, null)));
            Pattern entryPattern = Pattern.compile(PMStatEntry.getString(PMStatEntry.Type.ENTRY_PATTERN));
            Pattern totalTimePattern = Pattern.compile(PMStatEntry.getString(PMStatEntry.Type.TIME_PATTERN));
            while ((line = statReader.readLine()) != null) {
                PMStatEntry statEntry;
                String delta;
                String event;
                String samples;
                Matcher match = entryPattern.matcher(line = line.trim());
                if (match.find()) {
                    samples = match.group(1);
                    event = match.group(2);
                    String usage = match.group(7);
                    String units = match.group(8);
                    delta = match.group(10);
                    String scale = match.group(14);
                    statEntry = new PMStatEntry(StatComparisonData.toFloat(samples), event, StatComparisonData.toFloat(usage), units, StatComparisonData.toFloat(delta), StatComparisonData.toFloat(scale));
                    result.add(statEntry);
                    continue;
                }
                if (!line.contains("seconds time elapsed") || !(match = totalTimePattern.matcher(line)).find()) continue;
                samples = match.group(1);
                event = match.group(2);
                delta = match.group(4);
                statEntry = new PMStatEntry(StatComparisonData.toFloat(samples), event, 0.0f, null, StatComparisonData.toFloat(delta), 0.0f);
                result.add(statEntry);
            }
            ArrayList<PMStatEntry> arrayList = result;
            return arrayList;
        }
        catch (IOException | URISyntaxException | CoreException e) {
            PerfPlugin.getDefault().openError((Exception)e, Messages.MsgError);
        }
        finally {
            try {
                if (statReader != null) {
                    statReader.close();
                }
            }
            catch (IOException e) {
                PerfPlugin.getDefault().openError(e, Messages.PerfResourceLeak_title);
            }
        }
        return result;
    }

    private String getFormat(String[][] table) {
        int[] maxCharLen = new int[table[0].length];
        int i = 0;
        while (i < table.length) {
            int j = 0;
            while (j < table[i].length) {
                maxCharLen[j] = Math.max(maxCharLen[j], table[i][j].length());
                ++j;
            }
            ++i;
        }
        ArrayList<Integer> arguments = new ArrayList<Integer>();
        int[] nArray = maxCharLen;
        int n = maxCharLen.length;
        int n2 = 0;
        while (n2 < n) {
            int length = nArray[n2];
            arguments.add(length);
            ++n2;
        }
        String entryFormat = String.format(PMStatEntry.getString(PMStatEntry.Type.ENTRY_FORMAT), arguments.toArray());
        return entryFormat;
    }

    public static float toFloat(String str) {
        try {
            return str == null ? 0.0f : Float.parseFloat(str.replace(",", ""));
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }
}

