/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.common.internal.pde.AbstractSimpleClassExtensionRegistryReader;
import org.eclipse.jst.jsf.common.internal.strategy.AbstractTestableExtensibleDefaultProviderSelectionStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.ISimpleStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.TestableProjectFactoryStrategy;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.DefaultJSFAppConfigLocatorProviderStrategy;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigLocatorProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigLocatorProviderStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeJSFAppConfigLocatorProviderStrategy
implements IJSFAppConfigLocatorProvider {
    public static final QualifiedName TESTABLE_FACTORY_SESSION_KEY = new QualifiedName("org.eclipse.jst.jsf.core", "LocatorProviderStrategyFactory");
    private IProject _project;

    public CompositeJSFAppConfigLocatorProviderStrategy(IProject project) {
        this._project = project;
    }

    @Override
    public List<IJSFAppConfigLocater> getLocators() {
        LocatorProviderSelectionStrategy providerSelector = new LocatorProviderSelectionStrategy();
        this.addLocatorProviderStrategies(providerSelector);
        IJSFAppConfigLocatorProvider provider = (IJSFAppConfigLocatorProvider)providerSelector.perform(this._project);
        if (provider != providerSelector.getNoResult()) {
            return Collections.unmodifiableList(provider.getLocators());
        }
        return Collections.emptyList();
    }

    private void addLocatorProviderStrategies(LocatorProviderSelectionStrategy providerSelector) {
        providerSelector.addDefaultStrategy(new DefaultJSFAppConfigLocatorProviderStrategy());
        providerSelector.addExtensionStrategy(new ExtensionPointLocatorProviderStrategy());
        providerSelector.addTestableStrategy((ISimpleStrategy)new TestableLocatorProviderStrategy());
    }

    private static class ExtensionPointLocatorProviderStrategy
    extends JSFAppConfigLocatorProviderStrategy {
        private ExtensionPointLocatorProviderStrategy() {
        }

        public IJSFAppConfigLocatorProvider perform(IProject input) throws Exception {
            JSFAppConfigLocatorProviderExtensionPointReader reader = new JSFAppConfigLocatorProviderExtensionPointReader();
            List res = reader.getExtensions();
            if (res != null && res.size() > 0) {
                return (IJSFAppConfigLocatorProvider)res.get(0);
            }
            return this.getNoResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSFAppConfigLocatorProviderExtensionPointReader
    extends AbstractSimpleClassExtensionRegistryReader<IJSFAppConfigLocatorProvider> {
        private static final String EXT_PT_ID = "jsfAppConfigLocatorProviderFactory";
        private static final String EXT_PT_ELEMENT = "locatorProvider";
        private static final String EXT_PT_ATTR = "class";

        protected JSFAppConfigLocatorProviderExtensionPointReader() {
            super("org.eclipse.jst.jsf.core", EXT_PT_ID, EXT_PT_ELEMENT, EXT_PT_ATTR, (Comparator)new AbstractSimpleClassExtensionRegistryReader.CompareOrgEclipseJstContributorsLastComparator());
        }

        protected void handleLoadFailure(CoreException ce) {
            JSFCorePlugin.log((Exception)((Object)ce), "Error loading JSFAppConfigLocatorProvider from extension");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocatorProviderSelectionStrategy
    extends AbstractTestableExtensibleDefaultProviderSelectionStrategy<IProject, IJSFAppConfigLocatorProvider> {
        private static final IJSFAppConfigLocatorProvider NO_RESULT = null;

        private LocatorProviderSelectionStrategy() {
        }

        public IJSFAppConfigLocatorProvider getNoResult() {
            return NO_RESULT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestableLocatorProviderStrategy
    extends TestableProjectFactoryStrategy<IJSFAppConfigLocatorProvider> {
        public TestableLocatorProviderStrategy() {
            super(TESTABLE_FACTORY_SESSION_KEY);
        }
    }
}

