/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class LifecycleMappingDiscoveryRequest {
    private final Map<IMavenProjectFacade, List<ILifecycleMappingRequirement>> allProjects = new LinkedHashMap<IMavenProjectFacade, List<ILifecycleMappingRequirement>>();
    private Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> allproposals;
    private final Set<IMavenDiscoveryProposal> selectedProposals = new LinkedHashSet<IMavenDiscoveryProposal>();
    private final Map<IMavenProjectFacade, Throwable> errors = new LinkedHashMap<IMavenProjectFacade, Throwable>();

    public Map<IMavenProjectFacade, List<ILifecycleMappingRequirement>> getProjects() {
        return this.allProjects;
    }

    public void setProposals(Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> proposals) {
        this.allproposals = proposals;
    }

    public List<IMavenDiscoveryProposal> getProposals(ILifecycleMappingRequirement requirement) {
        if (this.allproposals == null || requirement == null) {
            return Collections.emptyList();
        }
        List<IMavenDiscoveryProposal> result = this.allproposals.get(requirement);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> getAllProposals() {
        if (this.allproposals == null) {
            return Collections.emptyMap();
        }
        return this.allproposals;
    }

    public void addSelectedProposal(IMavenDiscoveryProposal proposal) {
        this.selectedProposals.add(proposal);
    }

    public void removeSelectedProposal(IMavenDiscoveryProposal proposal) {
        this.selectedProposals.remove(proposal);
    }

    public boolean isRequirementSatisfied(ILifecycleMappingRequirement requirement) {
        if (requirement == null) {
            return true;
        }
        if (this.allproposals == null || this.allproposals.isEmpty()) {
            return false;
        }
        List<IMavenDiscoveryProposal> proposals = this.allproposals.get(requirement);
        if (proposals != null) {
            for (IMavenDiscoveryProposal proposal : proposals) {
                if (!this.selectedProposals.contains(proposal)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappingComplete() {
        for (ILifecycleMappingRequirement packagingRequirement : this.getRequirements()) {
            if (this.isRequirementSatisfied(packagingRequirement)) continue;
            return false;
        }
        return true;
    }

    public void autoCompleteMapping() {
        for (Map.Entry<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> entry : this.getAllProposals().entrySet()) {
            List<IMavenDiscoveryProposal> proposals = entry.getValue();
            if (proposals == null || proposals.size() != 1) continue;
            this.addSelectedProposal(proposals.get(0));
        }
    }

    public IMavenDiscoveryProposal getSelectedProposal(ILifecycleMappingRequirement requirement) {
        if (this.allproposals == null) {
            return null;
        }
        List<IMavenDiscoveryProposal> proposals = this.allproposals.get(requirement);
        if (proposals == null) {
            return null;
        }
        for (IMavenDiscoveryProposal proposal : proposals) {
            if (!this.selectedProposals.contains(proposal)) continue;
            return proposal;
        }
        return null;
    }

    public List<IMavenDiscoveryProposal> getSelectedProposals() {
        return new ArrayList<IMavenDiscoveryProposal>(this.selectedProposals);
    }

    public void clearSelectedProposals() {
        this.selectedProposals.clear();
    }

    public void addProject(IMavenProjectFacade facade, ILifecycleMappingRequirement requirement) {
        if (facade != null && requirement != null) {
            List<ILifecycleMappingRequirement> requirements = this.allProjects.get(facade);
            if (requirements == null) {
                requirements = new ArrayList<ILifecycleMappingRequirement>();
            }
            requirements.add(requirement);
            this.allProjects.put(facade, requirements);
        }
    }

    public void addError(IMavenProjectFacade facade, Throwable th) {
        this.errors.put(facade, th);
    }

    public Map<IMavenProjectFacade, Throwable> getErrors() {
        return this.errors;
    }

    public Collection<ILifecycleMappingRequirement> getRequirements() {
        if (this.allProjects == null || this.allProjects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<ILifecycleMappingRequirement> requirements = new LinkedHashSet<ILifecycleMappingRequirement>();
        for (Map.Entry<IMavenProjectFacade, List<ILifecycleMappingRequirement>> entry : this.allProjects.entrySet()) {
            requirements.addAll((Collection<ILifecycleMappingRequirement>)entry.getValue());
        }
        return requirements;
    }
}

