/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.m2e.mavenarchiver.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenArchiverConfigurator
extends AbstractProjectConfigurator {
    private static final String GET_MANIFEST = "getManifest";
    private static final String MANIFEST_ENTRIES_NODE = "manifestEntries";
    private static final String ARCHIVE_NODE = "archive";
    private static final String CREATED_BY_ENTRY = "Created-By";
    private static final String MAVEN_ARCHIVER_CLASS = "org.apache.maven.archiver.MavenArchiver";
    private static final String M2E = "Maven Integration for Eclipse";
    private static final String GENERATED_BY_M2E = "Generated by Maven Integration for Eclipse";
    private static final boolean JDT_SUPPORTS_MODULES;

    static {
        boolean isModuleSupportAvailable = false;
        try {
            Class.forName("org.eclipse.jdt.core.IModuleDescription");
            isModuleSupportAvailable = true;
        }
        catch (Throwable throwable) {}
        JDT_SUPPORTS_MODULES = isModuleSupportAvailable;
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    protected abstract MojoExecutionKey getExecutionKey();

    public AbstractBuildParticipant getBuildParticipant(final IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        MojoExecutionKey key = this.getExecutionKey();
        if (execution.getArtifactId().equals(key.getArtifactId()) && execution.getGoal().equals(key.getGoal())) {
            return new AbstractBuildParticipant(){

                public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
                    IResourceDelta delta = this.getDelta(projectFacade.getProject());
                    boolean forceManifest = false;
                    if (delta != null) {
                        ManifestDeltaVisitor visitor = new ManifestDeltaVisitor();
                        delta.accept((IResourceDeltaVisitor)visitor);
                        forceManifest = visitor.foundManifest;
                    }
                    boolean forcePom = this.getBuildContext().hasDelta("pom.xml");
                    AbstractMavenArchiverConfigurator.this.mavenProjectChanged(projectFacade, null, forceManifest || forcePom, monitor);
                    if (!forcePom) {
                        IProject project = projectFacade.getProject();
                        IWorkspaceRoot root = project.getWorkspace().getRoot();
                        ArtifactKey mavenProject = projectFacade.getArtifactKey();
                        IPath outputPath = AbstractMavenArchiverConfigurator.this.getOutputDir(projectFacade).append("META-INF/maven").append(mavenProject.getGroupId()).append(mavenProject.getArtifactId());
                        IFile pom = root.getFolder(outputPath).getFile("pom.xml");
                        boolean bl = forcePom = !pom.exists();
                    }
                    if (forcePom) {
                        AbstractMavenArchiverConfigurator.this.writePom(projectFacade, monitor);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade oldFacade = event.getOldMavenProject();
        IMavenProjectFacade newFacade = event.getMavenProject();
        if (oldFacade == null && newFacade == null) {
            return;
        }
        this.mavenProjectChanged(newFacade, oldFacade, false, monitor);
    }

    public void mavenProjectChanged(IMavenProjectFacade newFacade, IMavenProjectFacade oldFacade, boolean forceGeneration, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder outputdir = root.getFolder(this.getOutputDir(newFacade));
        IFile manifest = outputdir.getFolder("META-INF").getFile("MANIFEST.MF");
        if (forceGeneration || this.needsNewManifest(manifest, oldFacade, newFacade, monitor)) {
            this.generateManifest(newFacade, manifest, monitor);
            this.refresh(newFacade, outputdir, monitor);
        }
    }

    protected abstract IPath getOutputDir(IMavenProjectFacade var1);

    protected void refresh(IMavenProjectFacade mavenFacade, IFolder outputdir, IProgressMonitor monitor) throws CoreException {
        if (outputdir.exists()) {
            try {
                outputdir.refreshLocal(2, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean needsNewManifest(IFile manifest, IMavenProjectFacade oldFacade, IMavenProjectFacade newFacade, IProgressMonitor monitor) {
        String newOrganizationName;
        if (!manifest.exists()) {
            return true;
        }
        if (oldFacade == null || oldFacade.getMavenProject() == null) {
            return false;
        }
        MavenProject newProject = newFacade.getMavenProject();
        MavenProject oldProject = oldFacade.getMavenProject();
        if (this.dependenciesChanged(oldProject.getArtifacts() == null ? null : new ArrayList<Artifact>(oldProject.getArtifacts()), newProject.getArtifacts() == null ? null : new ArrayList(newProject.getArtifacts()))) {
            return true;
        }
        Xpp3Dom oldArchiveConfig = this.getArchiveConfiguration(oldProject);
        Xpp3Dom newArchiveConfig = this.getArchiveConfiguration(newProject);
        if (newArchiveConfig != null && !newArchiveConfig.equals((Object)oldArchiveConfig) || oldArchiveConfig != null) {
            return true;
        }
        if (!newProject.getName().equals(oldProject.getName())) {
            return true;
        }
        String oldOrganizationName = oldProject.getOrganization() == null ? null : oldProject.getOrganization().getName();
        String string = newOrganizationName = newProject.getOrganization() == null ? null : newProject.getOrganization().getName();
        return newOrganizationName != null && !newOrganizationName.equals(oldOrganizationName) || oldOrganizationName != null && newOrganizationName == null;
    }

    private boolean dependenciesChanged(List<Artifact> artifacts, List<Artifact> others) {
        if (artifacts == others) {
            return false;
        }
        if (artifacts.size() != others.size()) {
            return true;
        }
        int i = 0;
        while (i < artifacts.size()) {
            Artifact dep2;
            Artifact dep = artifacts.get(i);
            if (!this.areEqual(dep, dep2 = others.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean areEqual(Artifact dep, Artifact other) {
        if (dep == other) {
            return true;
        }
        if (dep == null && other != null || dep != null && other == null) {
            return false;
        }
        return dep.toString().equals(other.toString()) && dep.isOptional() == other.isOptional();
    }

    protected Xpp3Dom getArchiveConfiguration(MavenProject mavenProject) {
        Plugin plugin = mavenProject.getPlugin(this.getPluginKey());
        if (plugin == null) {
            return null;
        }
        Xpp3Dom pluginConfig = (Xpp3Dom)plugin.getConfiguration();
        if (pluginConfig == null) {
            return null;
        }
        return pluginConfig.getChild(ARCHIVE_NODE);
    }

    /*
     * Loose catch block
     */
    public void generateManifest(IMavenProjectFacade mavenFacade, IFile manifest, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = mavenFacade.getMavenProject();
        Set originalArtifacts = mavenProject.getArtifacts();
        boolean parentHierarchyLoaded = false;
        try {
            MojoExecution mojoExecution;
            ClassLoader originalTCL;
            MavenSession session;
            block12: {
                MavenExecutionPlan executionPlan;
                this.markerManager.deleteMarkers((IResource)mavenFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.mavenarchiver.error");
                session = this.getMavenSession(mavenFacade, monitor);
                parentHierarchyLoaded = this.loadParentHierarchy(mavenFacade, monitor);
                originalTCL = Thread.currentThread().getContextClassLoader();
                ClassRealm projectRealm = mavenProject.getClassRealm();
                if (projectRealm != null && projectRealm != originalTCL) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                }
                if ((mojoExecution = this.getExecution(executionPlan = this.maven.calculateExecutionPlan(session, mavenProject, Collections.singletonList("package"), true, monitor), this.getExecutionKey())) != null) break block12;
                Thread.currentThread().setContextClassLoader(originalTCL);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            try {
                try {
                    IFolder destinationFolder = (IFolder)manifest.getParent();
                    M2EUtils.createFolder((IFolder)destinationFolder, (boolean)true, (IProgressMonitor)monitor);
                    mavenProject.setArtifacts(this.fixArtifactFileNames(mavenFacade));
                    this.reflectManifestGeneration(mavenFacade, mojoExecution, session, new File(manifest.getLocation().toOSString()));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalTCL);
                }
            }
            catch (Exception ex) {
                this.markerManager.addErrorMarkers((IResource)mavenFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.mavenarchiver.error", ex);
            }
        }
        finally {
            mavenProject.setArtifacts(originalArtifacts);
            if (parentHierarchyLoaded) {
                mavenProject.setParent(null);
            }
        }
    }

    private MavenSession getMavenSession(IMavenProjectFacade mavenFacade, IProgressMonitor monitor) throws CoreException {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMaven maven = MavenPlugin.getMaven();
        IFile pomResource = mavenFacade.getPom();
        MavenExecutionRequest request = projectManager.createExecutionRequest(pomResource, mavenFacade.getResolverConfiguration(), monitor);
        request.setOffline(MavenPlugin.getMavenConfiguration().isOffline());
        return maven.createSession(request, mavenFacade.getMavenProject());
    }

    private void reflectManifestGeneration(IMavenProjectFacade facade, MojoExecution mojoExecution, MavenSession session, File manifestFile) throws Exception {
        ClassLoader loader = null;
        Mojo mojo = null;
        Xpp3Dom originalConfig = mojoExecution.getConfiguration();
        Xpp3Dom customConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom("configuration"), (Xpp3Dom)originalConfig);
        MavenProject mavenProject = facade.getMavenProject();
        IProject project = facade.getProject();
        this.customizeManifest(customConfig, mavenProject);
        mojoExecution.setConfiguration(customConfig);
        mojo = (Mojo)this.maven.getConfiguredMojo(session, mojoExecution, Mojo.class);
        Class<?> mojoClass = mojo.getClass();
        loader = mojoClass.getClassLoader();
        try {
            Object archiver = this.getArchiverInstance(mojoClass, mojo, project);
            if (archiver != null) {
                Field archiveConfigurationField = this.findField(this.getArchiveConfigurationFieldName(), mojoClass);
                archiveConfigurationField.setAccessible(true);
                Object archiveConfiguration = archiveConfigurationField.get(mojo);
                Object mavenArchiver = this.getMavenArchiver(archiver, manifestFile, loader);
                Object manifest = this.getManifest(session, mavenProject, archiveConfiguration, mavenArchiver);
                Object userManifest = this.getProvidedManifest(manifest.getClass(), archiveConfiguration);
                this.mergeManifests(manifest, userManifest);
                this.writeManifest(manifestFile, manifest);
            }
        }
        finally {
            mojoExecution.setConfiguration(originalConfig);
            this.maven.releaseMojo((Object)mojo, mojoExecution);
        }
    }

    private void writeManifest(File manifestFile, Object manifest) throws UnsupportedEncodingException, FileNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PrintWriter printWriter = null;
        try {
            Method write = this.getWriteMethod(manifest);
            if (write != null) {
                printWriter = new PrintWriter(WriterFactory.newWriter((File)manifestFile, (String)"UTF-8"));
                write.invoke(manifest, printWriter);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private Object getManifest(MavenSession session, MavenProject mavenProject, Object archiveConfiguration, Object mavenArchiver) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object manifest = null;
        Class<?> archiveConfigClass = archiveConfiguration.getClass();
        try {
            Method getManifest = mavenArchiver.getClass().getMethod(GET_MANIFEST, MavenSession.class, MavenProject.class, archiveConfigClass);
            manifest = getManifest.invoke(mavenArchiver, session, mavenProject, archiveConfiguration);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method getManifest = mavenArchiver.getClass().getMethod(GET_MANIFEST, MavenProject.class, archiveConfigClass);
            manifest = getManifest.invoke(mavenArchiver, mavenProject, archiveConfiguration);
        }
        return manifest;
    }

    private Object getArchiverInstance(Class<? extends Mojo> mojoClass, Mojo mojo, IProject project) throws IllegalAccessException {
        Object archiver = null;
        Field archiverField = this.findField(this.getArchiverFieldName(), mojoClass);
        if (archiverField == null) {
            Field archiversField = this.findField("archivers", mojoClass);
            if (archiversField != null) {
                archiversField.setAccessible(true);
                Map archivers = (Map)archiversField.get(mojo);
                String key = this.isModular(project) ? "mjar" : "jar";
                archiver = archivers.get(key);
            }
        } else {
            archiverField.setAccessible(true);
            archiver = archiverField.get(mojo);
        }
        return archiver;
    }

    private boolean isModular(IProject project) {
        try {
            if (JDT_SUPPORTS_MODULES && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)project);
                return jp.getModuleDescription() != null;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private Method getWriteMethod(Object manifest) {
        Method[] methodArray = manifest.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] params;
            Method m = methodArray[n2];
            if ("write".equals(m.getName()) && (params = m.getParameterTypes()).length == 1 && Writer.class.isAssignableFrom(params[0])) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private boolean loadParentHierarchy(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject();
        try {
            if (mavenProject.getModel().getParent() == null || mavenProject.getParent() != null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        MavenExecutionRequest request = null;
        while (mavenProject != null && mavenProject.getModel().getParent() != null) {
            MavenProject parentProject;
            if (monitor.isCanceled()) break;
            if (request == null) {
                request = this.projectManager.createExecutionRequest(facade, monitor);
            }
            if ((parentProject = this.maven.resolveParentProject(request, mavenProject, monitor)) != null) {
                mavenProject.setParent(parentProject);
                loadedParent = true;
            }
            mavenProject = parentProject;
        }
        return loadedParent;
    }

    private Object getProvidedManifest(Class manifestClass, Object archiveConfiguration) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object newManifest;
        block9: {
            File manifestFile;
            FileReader reader;
            block8: {
                newManifest = null;
                reader = null;
                Method getManifestFile = archiveConfiguration.getClass().getMethod("getManifestFile", new Class[0]);
                manifestFile = (File)getManifestFile.invoke(archiveConfiguration, new Object[0]);
                if (manifestFile != null && manifestFile.exists() && manifestFile.canRead()) break block8;
                IOUtil.close(reader);
                return null;
            }
            try {
                reader = new FileReader(manifestFile);
                Constructor constructor = manifestClass.getConstructor(Reader.class);
                newManifest = constructor.newInstance(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtil.close(reader);
                break block9;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.close(reader);
                }
            }
            IOUtil.close((Reader)reader);
        }
        return newManifest;
    }

    private void mergeManifests(Object manifest, Object sourceManifest) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (sourceManifest == null) {
            return;
        }
        if (manifest instanceof Manifest && sourceManifest instanceof Manifest) {
            this.merge((Manifest)manifest, (Manifest)sourceManifest, false);
        } else {
            Method merge = manifest.getClass().getMethod("merge", sourceManifest.getClass());
            merge.invoke(manifest, sourceManifest);
        }
    }

    private void merge(Manifest target, Manifest other, boolean overwriteMain) {
        if (other != null) {
            Attributes mainAttributes = target.getMainAttributes();
            if (overwriteMain) {
                mainAttributes.clear();
                mainAttributes.putAll((Map<?, ?>)other.getMainAttributes());
            } else {
                this.mergeAttributes(mainAttributes, other.getMainAttributes());
            }
            for (Map.Entry<String, Attributes> o : other.getEntries().entrySet()) {
                Attributes ourSection = target.getAttributes(o.getKey());
                Attributes otherSection = o.getValue();
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    target.getEntries().put(o.getKey(), (Attributes)otherSection.clone());
                    continue;
                }
                this.mergeAttributes(ourSection, otherSection);
            }
        }
    }

    private void mergeAttributes(Attributes target, Attributes section) {
        for (Object o : section.keySet()) {
            Attributes.Name key = (Attributes.Name)o;
            Object value = section.get(o);
            target.put(key, value);
        }
    }

    protected abstract String getArchiverFieldName();

    protected String getArchiveConfigurationFieldName() {
        return ARCHIVE_NODE;
    }

    private Set<Artifact> fixArtifactFileNames(IMavenProjectFacade facade) throws IOException, CoreException {
        Set artifacts = facade.getMavenProject().getArtifacts();
        if (artifacts == null) {
            return null;
        }
        LinkedHashSet<Artifact> newArtifacts = new LinkedHashSet<Artifact>(artifacts.size());
        ArtifactRepository localRepo = MavenPlugin.getMaven().getLocalRepository();
        for (Artifact a : artifacts) {
            Artifact artifact;
            if (a.getFile().isDirectory() || "pom.xml".equals(a.getFile().getName())) {
                artifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getScope(), a.getType(), a.getClassifier(), a.getArtifactHandler());
                artifact.setFile(this.fakeFile(localRepo, a));
            } else {
                artifact = a;
            }
            newArtifacts.add(artifact);
        }
        return newArtifacts;
    }

    private void customizeManifest(Xpp3Dom customConfig, MavenProject mavenProject) throws CoreException {
        Xpp3Dom createdByNode;
        Xpp3Dom manifestEntriesNode;
        if (customConfig == null) {
            return;
        }
        Xpp3Dom archiveNode = customConfig.getChild(ARCHIVE_NODE);
        if (archiveNode == null) {
            archiveNode = new Xpp3Dom(ARCHIVE_NODE);
            customConfig.addChild(archiveNode);
        }
        if ((manifestEntriesNode = archiveNode.getChild(MANIFEST_ENTRIES_NODE)) == null) {
            manifestEntriesNode = new Xpp3Dom(MANIFEST_ENTRIES_NODE);
            archiveNode.addChild(manifestEntriesNode);
        }
        if ((createdByNode = manifestEntriesNode.getChild(CREATED_BY_ENTRY)) == null) {
            createdByNode = new Xpp3Dom(CREATED_BY_ENTRY);
            createdByNode.setValue(M2E);
            manifestEntriesNode.addChild(createdByNode);
        }
    }

    private Field findField(String name, Class<?> clazz) {
        return ReflectionUtils.getFieldByNameIncludingSuperclasses((String)name, clazz);
    }

    private Object getMavenArchiver(Object archiver, File manifestFile, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class<?> mavenArchiverClass = Class.forName(MAVEN_ARCHIVER_CLASS, false, loader);
        Object mavenArchiver = mavenArchiverClass.newInstance();
        Method setArchiver = null;
        Method[] methodArray = mavenArchiver.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if ("setArchiver".equals(m.getName())) {
                setArchiver = m;
                break;
            }
            ++n2;
        }
        setArchiver.invoke(mavenArchiver, archiver);
        Method setOutputFile = mavenArchiverClass.getMethod("setOutputFile", File.class);
        setOutputFile.invoke(mavenArchiver, manifestFile);
        return mavenArchiver;
    }

    private String getPluginKey() {
        MojoExecutionKey execution = this.getExecutionKey();
        return String.valueOf(execution.getGroupId()) + ":" + execution.getArtifactId();
    }

    private MojoExecution getExecution(MavenExecutionPlan executionPlan, MojoExecutionKey key) {
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!key.getArtifactId().equals(execution.getArtifactId()) || !key.getGroupId().equals(execution.getGroupId()) || !key.getGoal().equals(execution.getGoal())) continue;
            return execution;
        }
        return null;
    }

    private File fakeFile(ArtifactRepository localRepo, Artifact artifact) throws IOException {
        File fakeRepo = new File(System.getProperty("java.io.tmpdir"), "fakerepo");
        File fakeFile = new File(fakeRepo, localRepo.pathOf(artifact));
        File parent = fakeFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!fakeFile.exists()) {
            fakeFile.createNewFile();
        }
        return fakeFile;
    }

    protected void writePom(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IProject project = facade.getProject();
        ArtifactKey mavenProject = facade.getArtifactKey();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        IPath outputPath = this.getOutputDir(facade).append("META-INF/maven").append(mavenProject.getGroupId()).append(mavenProject.getArtifactId());
        IFolder output = root.getFolder(outputPath);
        M2EUtils.createFolder((IFolder)output, (boolean)true, (IProgressMonitor)monitor);
        Properties properties = new Properties();
        properties.put("groupId", mavenProject.getGroupId());
        properties.put("artifactId", mavenProject.getArtifactId());
        properties.put("version", mavenProject.getVersion());
        properties.put("m2e.projectName", project.getName());
        properties.put("m2e.projectLocation", project.getLocation().toOSString());
        IFile pomProperties = output.getFile("pom.properties");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            properties.store(buf, GENERATED_BY_M2E);
        }
        catch (IOException iOException) {}
        if (pomProperties.exists()) {
            pomProperties.setContents((InputStream)new ByteArrayInputStream(buf.toByteArray()), 1, monitor);
        } else {
            pomProperties.create((InputStream)new ByteArrayInputStream(buf.toByteArray()), 1, monitor);
        }
        IFile pom = output.getFile("pom.xml");
        InputStream is = facade.getPom().getContents();
        try {
            if (pom.exists()) {
                pom.setContents(is, 1, monitor);
            } else {
                pom.create(is, 1, monitor);
            }
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    private class ManifestDeltaVisitor
    implements IResourceDeltaVisitor {
        private final String MANIFEST = "MANIFEST.MF";
        boolean foundManifest;

        private ManifestDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getResource() instanceof IFile && "MANIFEST.MF".equals(delta.getResource().getName())) {
                this.foundManifest = true;
            }
            return !this.foundManifest;
        }
    }
}

