/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JpaMoveFolderParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected final Map<IFolder, MoveArguments> originalFolders = new HashMap<IFolder, MoveArguments>();
    protected final Map<IFile, Iterable<ReplaceEdit>> persistenceXmlReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();

    public String getName() {
        return JptJpaCoreRefactoringMessages.JPA_MOVE_FOLDER_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.originalFolders.put((IFolder)element, (MoveArguments)arguments);
    }

    protected MoveArguments getArguments(IFolder element) {
        return this.originalFolders.get(element);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JptJpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        Iterable<JpaProject> jpaProjects = this.getJpaProjects();
        int size = IterableTools.size(jpaProjects);
        if (size == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + 1));
        sm.subTask(JptJpaCoreRefactoringMessages.JPA_MOVE_FOLDER_REFACTORING_SUB_TASK_NAME);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjects) {
            this.createReplaceEdits(jpaProject);
            sm.worked(10);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile persistenceXmlFile : this.persistenceXmlReplaceEdits.keySet()) {
            deltaFactory.change(persistenceXmlFile);
        }
        sm.worked(1);
        return null;
    }

    protected Iterable<JpaProject> getJpaProjects() throws OperationCanceledException {
        try {
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            return jpaProjectManager != null ? jpaProjectManager.waitToGetJpaProjects() : IterableTools.emptyIterable();
        }
        catch (InterruptedException ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    protected JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    protected void createReplaceEdits(JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        Iterable<ReplaceEdit> replaceEdits = this.createPersistenceUnitReplaceEditsCheckClasspath(persistenceUnit);
        if (!IterableTools.isEmpty(replaceEdits)) {
            this.persistenceXmlReplaceEdits.put(jpaProject.getPersistenceXmlResource().getFile(), replaceEdits);
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlReplaceEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.persistenceXmlReplaceEdits.size());
        sm.subTask(JptJpaCoreRefactoringMessages.JPA_MOVE_FOLDER_REFACTORING_SUB_TASK_NAME);
        CompositeChange compositeChange = new CompositeChange(JptJpaCoreRefactoringMessages.JPA_MOVE_FOLDER_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlReplaceEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addPersistenceXmlRenameChange(persistenceXmlFile, compositeChange);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEditsCheckClasspath(PersistenceUnit persistenceUnit) {
        return IterableTools.children(this.getOriginalFoldersOnClasspath(persistenceUnit.getJpaProject()), (Transformer)new PersistenceUnitReplaceEditsTransformer(persistenceUnit));
    }

    protected Iterable<IFolder> getOriginalFoldersOnClasspath(JpaProject jpaProject) {
        IJavaProject javaProject = jpaProject.getJavaProject();
        return IterableTools.filter(this.originalFolders.keySet(), (Predicate)new JavaProjectTools.ResourceIsOnClasspath(javaProject));
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEdits(PersistenceUnit persistenceUnit, IFolder folder, IContainer destination) {
        IProject project = destination.getProject();
        IPath fullPath = destination.getFullPath().append(folder.getName());
        ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        IPath runtimePath = locator.getRuntimePath(fullPath);
        return persistenceUnit.createMoveFolderEdits(folder, runtimePath);
    }

    protected void addPersistenceXmlRenameChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JptJpaCoreRefactoringMessages.JPA_MOVE_FOLDER_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        Iterable<ReplaceEdit> mappingFileReplaceEdits = this.persistenceXmlReplaceEdits.get(persistenceXmlFile);
        this.addEdits(textChange, mappingFileReplaceEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException e) {
                JptJpaCorePlugin.instance().logError(e);
            }
        }
    }

    class PersistenceUnitReplaceEditsTransformer
    extends TransformerAdapter<IFolder, Iterable<ReplaceEdit>> {
        private final PersistenceUnit persistenceUnit;

        PersistenceUnitReplaceEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<ReplaceEdit> transform(IFolder folder) {
            return JpaMoveFolderParticipant.this.createPersistenceUnitReplaceEdits(this.persistenceUnit, folder, (IContainer)JpaMoveFolderParticipant.this.getArguments(folder).getDestination());
        }
    }
}

