/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialog;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddRedefinedComponentCommand;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDRedefinableComponent;
import org.eclipse.xsd.XSDRedefine;

public abstract class AddXSDRedefinableContentAction
extends XSDBaseAction {
    protected AddXSDRedefinableContentAction(IWorkbenchPart part, String ID, String text) {
        super(part);
        this.setText(text);
        this.setId(ID);
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            selection = ((XSDBaseAdapter)selection).getTarget();
        }
        if (selection instanceof XSDRedefine) {
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setDescriptionProvider((IComponentDescriptionProvider)new RedefineDescriptor());
            configuration.setSearchListProvider((IComponentSearchListProvider)new RedefineSearchListProvider((XSDRedefine)selection, this));
            ComponentSearchListDialog dialog = new ComponentSearchListDialog(Display.getDefault().getActiveShell(), Messages._UI_LABEL_REDEFINE_COMPONENT, configuration){

                protected Control createDialogArea(Composite parent) {
                    Composite mainComposite = (Composite)super.createDialogArea(parent);
                    GridData gridData = (GridData)mainComposite.getLayoutData();
                    gridData.heightHint = 500;
                    gridData.widthHint = 350;
                    return mainComposite;
                }
            };
            dialog.create();
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            if (result == 0) {
                ComponentSpecification selectedComponent = dialog.getSelectedComponent();
                this.buildRedefine((XSDRedefine)selection, selectedComponent);
            }
        }
    }

    protected abstract AddRedefinedComponentCommand getCommand(XSDRedefine var1, XSDRedefinableComponent var2);

    protected abstract void buildComponentsList(XSDRedefine var1, Set var2, IComponentList var3);

    protected void buildRedefine(XSDRedefine redefine, ComponentSpecification selectedComponent) {
        XSDRedefinableComponent redefinableComponent = (XSDRedefinableComponent)selectedComponent.getObject();
        AddRedefinedComponentCommand command = this.getCommand(redefine, redefinableComponent);
        this.getCommandStack().execute((Command)command);
        this.addedComponent = command.getAddedComponent();
    }

    protected abstract Image getRedefinedComponentImage();

    class RedefineDescriptor
    implements IComponentDescriptionProvider {
        RedefineDescriptor() {
        }

        public IFile getFile(Object component) {
            if (component instanceof XSDNamedComponent) {
                if (((XSDNamedComponent)component).getSchema() == null) {
                    return null;
                }
                String location = ((XSDNamedComponent)component).getSchema().getSchemaLocation();
                String platformResource = "platform:/resource";
                if (location != null && location.startsWith(platformResource)) {
                    Path path = new Path(location.substring(platformResource.length()));
                    return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                }
            }
            return null;
        }

        public Image getFileIcon(Object component) {
            return XSDEditorPlugin.getXSDImage("icons/XSDFile.gif");
        }

        public ILabelProvider getLabelProvider() {
            return new XSDRedefineComponentsLabelProvider();
        }

        public String getName(Object component) {
            if (component instanceof XSDNamedComponent) {
                return ((XSDNamedComponent)component).getName();
            }
            return "";
        }

        public String getQualifier(Object component) {
            if (component instanceof XSDNamedComponent) {
                return ((XSDNamedComponent)component).getTargetNamespace();
            }
            return "";
        }

        public boolean isApplicable(Object component) {
            return true;
        }
    }

    class RedefineSearchListProvider
    implements IComponentSearchListProvider {
        XSDRedefine xsdRedefine;
        AddXSDRedefinableContentAction action;

        public RedefineSearchListProvider(XSDRedefine xsdRedefine, AddXSDRedefinableContentAction action) {
            this.xsdRedefine = xsdRedefine;
            this.action = action;
        }

        public void populateComponentList(IComponentList list, SearchScope scope, IProgressMonitor pm) {
            EList currentRedefines = this.xsdRedefine.getContents();
            HashSet<String> redefinedComponentsNames = new HashSet<String>(currentRedefines.size());
            Iterator redefinesIterator = currentRedefines.iterator();
            while (redefinesIterator.hasNext()) {
                XSDRedefinableComponent component = (XSDRedefinableComponent)redefinesIterator.next();
                String redefinedComponentName = component.getName();
                redefinedComponentsNames.add(redefinedComponentName);
            }
            this.action.buildComponentsList(this.xsdRedefine, redefinedComponentsNames, list);
        }
    }

    class XSDRedefineComponentsLabelProvider
    implements ILabelProvider {
        XSDRedefineComponentsLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = AddXSDRedefinableContentAction.this.getRedefinedComponentImage();
            return image;
        }

        public String getText(Object element) {
            if (element instanceof XSDNamedComponent) {
                return ((XSDNamedComponent)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

