/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.dependencyset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DependencySetRefactoring
extends Refactoring {
    private final IFile file;
    private final List<ArtifactKey> keys;

    public DependencySetRefactoring(IFile file, List<ArtifactKey> keys) {
        this.file = file;
        this.keys = keys;
    }

    public String getName() {
        return "Set dependency version";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<OneDependency> operations = new ArrayList<OneDependency>();
        for (ArtifactKey key : this.keys) {
            operations.add(new OneDependency(key));
        }
        PomEdits.CompoundOperation compound = new PomEdits.CompoundOperation(operations.toArray(new PomEdits.Operation[0]));
        return PomHelper.createChange((IFile)this.file, (PomEdits.Operation)compound, (String)this.getName());
    }

    private static class OneDependency
    implements PomEdits.Operation {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public OneDependency(ArtifactKey key) {
            this.groupId = key.getGroupId();
            this.artifactId = key.getArtifactId();
            this.version = key.getVersion();
        }

        public void process(Document document) {
            Element deps = PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies");
            Element existing = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)this.groupId), PomEdits.childEquals((String)"artifactId", (String)this.artifactId)});
            if (existing != null) {
                PomEdits.setText((Element)PomEdits.getChild((Element)existing, (String[])new String[]{"version"}), (String)this.version);
            } else {
                Element dm = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencyManagement", "dependencies"});
                existing = PomEdits.findChild((Element)dm, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)this.groupId), PomEdits.childEquals((String)"artifactId", (String)this.artifactId)});
                if (existing != null) {
                    PomEdits.setText((Element)PomEdits.getChild((Element)existing, (String[])new String[]{"version"}), (String)this.version);
                } else {
                    PomHelper.createDependency((Element)dm, (String)this.groupId, (String)this.artifactId, (String)this.version);
                }
            }
        }
    }
}

