// ForthCompiler.h
//
// Copyright (c) 1998--2009 Krishna Myneni, Creative Consulting for
//   Research and Education
//
// This software is provided under the terms of the GNU General Public License.
//
// Revisions: 
//   2005-09-19
//   2006-03-16  incremented NUMBER_OF_INTRINSIC_WORDS
//               ...
//   2006-04-07  ... by 8 dnw
//   2006-04-08  NUMBER_OF_INTRINSIC_WORDS replaced
//                           by calculation dnw
//   2008-03-17  added declaration of CompileWord()  km
//   2008-03-21  fixed declaration of IsFloat to use argument of type
//                 double* rather than float*  km
//   2008-07-05  changed declaration of WordTemplate member WordName
//                 from char* to const char* to avoid gcc 4.2.x warnings  km
//   2009-10-04  changed DictionaryEntry to WordListEntry; added 
//                 SearchList  km
//   2009-10-12  changed return type of IsForthWord() and isBaseDigit() 
//                 to bool; added type definition of WordIndex; reworked
//                 member functions of WordList and SearchList classes km
//   2009-10-13  made Vocabulary a derived class of WordList, which considerably
//                 simplifies references  km
//   2009-11-24  added member function Initialize() to class Vocabulary  km
//   2009-11-25  removed declarations for ExtractName(), IsFloat(), 
//                 isBaseDigit(), and IsInt() --- these functions have
//                 been moved to vmc.c  km

#ifndef __FORTHCOMPILER_H__
#define __FORTHCOMPILER_H__

#define byte unsigned char
#define word unsigned short int

#define PRECEDENCE_NONE         0
#define PRECEDENCE_IMMEDIATE    1
#define PRECEDENCE_NON_DEFERRED 2
#define EXECUTE_NONE            0
#define EXECUTE_UP_TO           1
#define EXECUTE_CURRENT_ONLY    2
#define TRUE -1
#define FALSE 0
#define MAX_C_ERR_MESSAGES 13

// Error codes; The corresponding error messages are given in
//   the const char* array C_ErrorMessages, in ForthCompiler.cpp

#define E_C_NOERROR         0x100
#define E_C_ENDOFSTREAM     0x101
#define E_C_ENDOFDEF        0x102
#define E_C_ENDOFSTRING     0x103
#define E_C_NOTINDEF        0x104
#define E_C_OPENFILE        0x105
#define E_C_INCOMPLETEIF    0x106
#define E_C_INCOMPLETEBEGIN 0x107
#define E_C_UNKNOWNWORD     0x108
#define E_C_NODO            0x109
#define E_C_INCOMPLETELOOP  0x10A
#define E_C_INCOMPLETECASE  0x10B
#define E_C_VMERROR         0x10C

struct WordTemplate
{
    const char* WordName;
    word WordCode;
    byte Precedence;
};

struct WordListEntry
{
  char WordName[32];
  word WordCode;
  byte Precedence;
  void* Cfa;
  void* Pfa;
};

typedef vector<WordListEntry>::iterator  WordIndex;

class WordList : public vector<WordListEntry> 
{
public:
   bool RetrieveFromName( char*, WordListEntry* );
   bool RetrieveFromCfa( void*, WordListEntry* );
   WordIndex IndexOf( char* );
   void RemoveLastWord( void );
};

class Vocabulary : public WordList
{
public:
   const char* Name;
   Vocabulary (const char* );
   int Initialize (WordTemplate [], int);
};

class SearchList : public vector<Vocabulary*>
{
public:
   bool LocateWord( char*, WordListEntry* );
   bool LocateCfa( void* cfa, WordListEntry* );
};


bool IsForthWord (char*, WordListEntry*);
int  ForthCompiler (vector<byte>*, int*);
void CompileWord (WordListEntry);
void OutputForthByteCode (vector<byte>*);
void SetForthInputStream (istream&);
void SetForthOutputStream (ostream&);

#endif
