\
\ determ.4th
\
\ Return the determinant of a real square matrix.
\ The input matrix is destroyed in the process.

\ Copyright (c) 1998--2007 Krishna Myneni,
\ Creative Consulting for Research and Education
\ http://ccreweb.org
\
\ Revisions: 
\ 
\   2007-09-16  extract word determ from original kForth matrix
\               package into its own module, and modify to use
\               FSL-style matrices; also use ttester for testing  km
\
\ determ is based on a similar routine from P.R. Bevington,
\   "Data Reduction and Error Analysis for the Physical Sciences",
\   1969, McGraw-Hill.
\

0 value L
0 value Norder		\ order of matrix 
0 ptr arr{{		\ address of matrix ( ptr is same as VALUE in ANS-Forth)


: determ ( 'a n -- fdet | a is the matrix, n is its order )
    to Norder  to arr{{
    1e 
	
    Norder 0 DO
	arr{{ I I }} F@  F0= IF
	    \ Find next element in row which is non-zero
	    I 1+ to L
	    L Norder = IF  fdrop 0e LEAVE  THEN
	    
	    BEGIN
		arr{{ I L }} F@  F0= 
		L Norder 1- < and
	    WHILE
		    L 1+ to L
	    REPEAT

	    arr{{ I L }} F@  F0= IF  fdrop 0e LEAVE  THEN

	    \ Swap columns I and k (for lower portion of matrix)
	    
	    Norder I DO
		arr{{ I L }} F@  arr{{ I J }} F@
		arr{{ I L }} F!  arr{{ I J }} F!
	    LOOP
	    fnegate
	THEN
	
	\ Accumulate product of diagonal elements for diagonal matrix
	arr{{ I I }} F@ F*

	I to L
	\ Subtract row k from lower rows to get diagonal matrix

	L Norder 1- < IF
	    Norder L 1+ DO
		Norder L 1+ DO
		    arr{{ J I }} F@  arr{{ J L }} F@
		    arr{{ L I }} F@  arr{{ L L }} F@
		    F/ F* F-  arr{{ J I }} F!
		LOOP
	    LOOP
	THEN
    LOOP
;

TEST-CODE? [IF]   \ test code ==============================================
[undefined] T{      [IF]  include ttester.4th  [THEN]
DECIMAL

1e-15 rel-near F!
1e-15 abs-near F!
set-near

2 2 FLOAT MATRIX m2{{
    3e  1e
    5e  2e
2 2 m2{{ }}fput

3 3 FLOAT MATRIX m3{{
    1e  2e  3e
    2e  1e  1e
    3e  1e  2e
3 3 m3{{ }}fput

4 4 FLOAT MATRIX m4{{
    2e  1e  4e  2e
    0e  2e  1e  2e
    0e  2e  1e  1e
    2e  0e  1e  0e
4 4 m4{{ }}fput

t{ m2{{ 2 determ  ->   1e  r}t
t{ m3{{ 3 determ  ->  -4e  r}t
t{ m4{{ 4 determ  -> -10e  r}t  

[THEN]
