\ serial.4th
\
\ kForth interface words for Linux serial communcations.
\
\ Copyright (c) 2000--2007 David P. Wallace, Krishna Myneni
\ Provided under the terms of the GNU General Public License
\
\ Requires:
\
\       ans-words.4th
\	strings.4th
\       struct.4th
\       struct-ext.4th
\
\ Revisions:
\
\	3-13-2000  first working version
\	6-03-2001  modified serial_open to disable XON/XOFF flow control,
\	             added bit constants for c_iflag, etc.,
\		     modified serial_setparams for readability  KM
\      12-13-2001  modified serial_open to disable CR to NL translation.  KM
\       8-03-2007  revised to use structure definition for termios,
\                    included J. Zakiya's refactorization of the
\                    serial_setxxx words, replaced NOT with INVERT,
\                    and fixed stack diagram for serial_close KM

\ termios structure

struct
    int:    C_IFLAG
    int:    C_OFLAG
    int:    C_CFLAG
    int:    C_LFLAG
    int16:  C_LINE
    64 buf: C_CC
    int:    C_ISPEED
    int:    C_OSPEED
end-struct termios%

create termios termios% %allot drop


\ c_iflag bits

   1 constant IGNBRK
   2 constant BRKINT
   4 constant IGNPAR
   8 constant PARMRK
  16 constant INPCK
  32 constant ISTRIP
  64 constant INLCR
 128 constant IGNCR
 256 constant ICRNL
 512 constant IUCLC
1024 constant IXON
2048 constant IXANY
4096 constant IXOFF
8192 constant IMAXBEL

\ c_oflag bits

   1 constant OPOST
   2 constant OLCUC
   4 constant ONLCR
   8 constant OCRNL
  16 constant ONOCR
  32 constant ONLRET
  64 constant OFILL
 128 constant OFDEL
 256 constant NLDLY

\ c_cflag bits
			\ baud rates constants
4111 constant CBAUD
   0 constant B0
   7 constant B300
   9 constant B1200
  11 constant B2400
  12 constant B4800
  13 constant B9600
  14 constant B19200
  15 constant B38400
4097 constant B57600
4098 constant B115200
			\ character size constants
  48 constant CSIZE
   0 constant CS5
  16 constant CS6
  32 constant CS7
  48 constant CS8

\ parity constants

768 constant CPARITY
  0 constant PARNONE
256 constant PAREVEN
768 constant PARODD

\ stop bits constants

64 constant CSTOPB
0 constant ONESTOPB
64 constant TWOSTOPB

\ c_lflag bits

   1 constant ISIG
   2 constant ICANON
   4 constant XCASE
   8 constant ECHO
  16 constant ECHOE
  32 constant ECHOK
  64 constant ECHONL
 128 constant NOFLSH
 256 constant TOSTOP
 512 constant ECHOCTL
1024 constant ECHOPRT
2048 constant ECHOKE
4096 constant FLUSHO
16384 constant PENDIN
32768 constant IEXTEN

\ com port constants

0 constant COM1
1 constant COM2
2 constant COM3
3 constant COM4


\ ioctl request constants

hex
5401 constant TCGETS
5402 constant TCSETS
540B constant TCFLSH
541B constant FIONREAD
decimal

\ file control constants

hex
800 constant O_NDELAY
100 constant O_NOCTTY
002 constant O_RDWR
decimal


: serial_getoptions ( handle -- | read serial port options into termios )
    TCGETS termios ioctl drop ;
	
: serial_setoptions ( handle -- | write termios into serial port options )
    TCSETS termios ioctl drop ;
	
: serial_open ( port -- handle | opens the serial port for communcation )
    \ port is the serial port to open
    \ 0 = ttyS0 (COM1)
    \ 1 = ttyS1 (COM2)
    \ 2 = ttyS2 (COM3)
    \ 3 = ttyS3 (COM4)
    \ handle is a handle to the open serial port
    \ if handle < 0 there was an error opening the port
    dup
    0 >= IF
	s>string count
	s" /dev/ttyS" 2swap strcat strpck
	O_RDWR O_NOCTTY  O_NDELAY or or  open
	dup
	dup serial_getoptions
	
	\ Disable XON/XOFF flow control and CR to NL mapping

	termios C_IFLAG @
	IXON IXOFF or IXANY or ICRNL or invert and
	termios C_IFLAG !

	\ Open for raw input

	termios C_LFLAG @
	ISIG ICANON or ECHO or ECHOE or invert
	and  termios C_LFLAG !

	\ Open for raw output

	termios C_OFLAG @
	OPOST invert
	and  termios C_OFLAG !
	serial_setoptions
    THEN ;
	
: serial_close ( handle -- ior | closes the port )
    \ handle = serial port handle received from serial_open	
    close ;

: serial_write ( handle buf num_to_write -- num_written )
    \ handle = serial port handle received from serial_open
    \ buf = address to buffer that holds chars to be written
    \ num_to_write = number of chars to write
    \ num_written = number of chars actually written
    write ;
	
: serial_read ( handle buf num_to_read -- num_read )
    \ handle = serial port handle received from serial_open
    \ buf = address to buffer to hold chars to being read
    \ num_to_read = number of chars to read
    \ num_read = number of chars actually read
    read ;

: serial_set_bits ( handle value parameter -- )
    \ handle = serial port handle received from serial_open
    \ value = desired value for parameter ( use constants defined above )
    \ parameter (CBAUD, CPARITY, CSTOPB, CSIZE)
    >r   \ save mask
    swap dup
    serial_getoptions
    \ set the parameter
    swap
    termios C_CFLAG @
    r> invert and  or
    termios C_CFLAG !
    serial_setoptions ;

: serial_setbaud ( handle baud -- )  CBAUD  serial_set_bits ;

: serial_setparity ( handle parity -- )  CPARITY  serial_set_bits ;

: serial_setstopbits ( handle stopbits -- )  CSTOPB  serial_set_bits ;

: serial_setdatabits ( handle databits -- )  CSIZE  serial_set_bits ;

: serial_flush ( handle -- )
    \ handle = serial port handle received from serial_open
    TCFLSH 2 ioctl drop ;

variable inque
	
: serial_lenrx ( handle -- rx_len)
    \ handle = serial port handle received from serial_open
    \ rx_len = number of chars in recieve que
    FIONREAD inque ioctl drop
    inque @ ;	 	

: serial_setparams ( handle ^str -- )
    \ ^str examples are 8N1, 7E1, etc.
    swap >r
    dup 1+ c@
    CASE
	[char] 8  OF  r@ CS8 serial_setdatabits  ENDOF
	[char] 7  OF  r@ CS7 serial_setdatabits  ENDOF
    ENDCASE

    dup	2+ c@
    CASE
	[char] N  OF  r@ PARNONE serial_setparity  ENDOF
	[char] E  OF  r@ PAREVEN serial_setparity  ENDOF
	[char] O  OF  r@ PARODD serial_setparity   ENDOF
    ENDCASE

    3 + c@
    CASE
	[char] 1  OF  r@ ONESTOPB serial_setstopbits  ENDOF
	[char] 2  OF  r@ TWOSTOPB serial_setstopbits  ENDOF
    ENDCASE
	
    r> drop ;
	
