/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.common.Formatter;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.MatcherPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInvalidInputErrorFormatter
implements Formatter<InvalidInputError> {
    @Override
    public String format(InvalidInputError invalidInputError) {
        if (invalidInputError == null) {
            return "";
        }
        int n = invalidInputError.getEndIndex() - invalidInputError.getStartIndex();
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            char c = invalidInputError.getInputBuffer().charAt(invalidInputError.getStartIndex());
            if (c == '\uffff') {
                stringBuilder.append("Unexpected end of input");
            } else {
                stringBuilder.append("Invalid input '").append(StringUtils.escape(String.valueOf(c)));
                if (n > 1) {
                    stringBuilder.append("...");
                }
                stringBuilder.append('\'');
            }
        } else {
            stringBuilder.append("Invalid input");
        }
        String string = this.getExpectedString(invalidInputError);
        if (StringUtils.isNotEmpty(string)) {
            stringBuilder.append(", expected ").append(string);
        }
        return stringBuilder.toString();
    }

    public String getExpectedString(InvalidInputError invalidInputError) {
        int n = invalidInputError.getStartIndex() - invalidInputError.getIndexDelta();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MatcherPath matcherPath : invalidInputError.getFailedMatchers()) {
            String[] stringArray;
            Matcher matcher = ErrorUtils.findProperLabelMatcher(matcherPath, n);
            if (matcher == null) continue;
            for (String string : stringArray = this.getLabels(matcher)) {
                if (string == null || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return this.join(arrayList);
    }

    public String[] getLabels(Matcher matcher) {
        if (matcher instanceof AnyOfMatcher && ((AnyOfMatcher)matcher).characters.toString().equals(matcher.getLabel())) {
            AnyOfMatcher anyOfMatcher = (AnyOfMatcher)matcher;
            if (!anyOfMatcher.characters.isSubtractive()) {
                String[] stringArray = new String[anyOfMatcher.characters.getChars().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = '\'' + String.valueOf(anyOfMatcher.characters.getChars()[i]) + '\'';
                }
                return stringArray;
            }
        }
        return new String[]{matcher.getLabel()};
    }

    public String join(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(i < list.size() - 1 ? ", " : " or ");
            }
            stringBuilder.append(list.get(i));
        }
        return StringUtils.escape(stringBuilder.toString());
    }
}

