/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnsync;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svnsync.SVNSyncCommand;
import org.tmatesoft.svn.cli.svnsync.SVNSyncOption;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSyncSynchronizeCommand
extends SVNSyncCommand
implements ISVNAdminEventHandler {
    public SVNSyncSynchronizeCommand() {
        super("synchronize", new String[]{"sync"}, 0);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNSyncOption> options = new LinkedList<SVNSyncOption>();
        options.add(SVNSyncOption.NON_INTERACTIVE);
        options.add(SVNSyncOption.NO_AUTH_CACHE);
        options.add(SVNSyncOption.USERNAME);
        options.add(SVNSyncOption.PASSWORD);
        options.add(SVNSyncOption.TRUST_SERVER_CERT);
        options.add(SVNSyncOption.SOURCE_USERNAME);
        options.add(SVNSyncOption.SOURCE_PASSWORD);
        options.add(SVNSyncOption.SYNC_USERNAME);
        options.add(SVNSyncOption.SYNC_PASSWORD);
        options.add(SVNSyncOption.CONFIG_DIR);
        options.add(SVNSyncOption.QUIET);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNPath toURL;
        SVNErrorMessage err;
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.size() > 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (!(toURL = new SVNPath(targets.get(0))).isURL()) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Path ''{0}'' is not a URL", (Object)toURL.getTarget());
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        }
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        client.setEventHandler(this);
        client.setReplayHandler(new ISVNLogEntryHandler(){

            @Override
            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                SVNSyncSynchronizeCommand.this.getEnvironment().getOut().println("Committed revision " + logEntry.getRevision() + ".");
            }
        });
        client.doSynchronize(toURL.getURL());
    }

    @Override
    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (!(event.getAction() != SVNAdminEventAction.REVISION_PROPERTIES_COPIED && event.getAction() != SVNAdminEventAction.NORMALIZED_PROPERTIES || this.getSVNSyncEnvironment().isQuiet())) {
            this.getSVNSyncEnvironment().getOut().println(event.getMessage());
        }
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
    }
}

